/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.KeyValueStateMachine;
import ai.eloquent.raft.RaftLog;
import ai.eloquent.raft.RaftLogEntryLocation;
import ai.eloquent.raft.RaftStateMachine;
import ai.eloquent.util.Span;
import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.ExecutorService;

public class RaftState {
    public final String serverName;
    public final RaftLog log;
    public long currentTerm = 0L;
    public Optional<String> votedFor = Optional.empty();
    public final int targetClusterSize;
    public volatile LeadershipStatus leadership = LeadershipStatus.OTHER;
    public volatile long electionTimeoutCheckpoint = -1L;
    public volatile Optional<String> leader = Optional.empty();
    public volatile Set<String> votesReceived = new HashSet<String>();
    public volatile Optional<Map<String, Long>> nextIndex = Optional.empty();
    public volatile Optional<Map<String, Long>> matchIndex = Optional.empty();
    public volatile Optional<Map<String, Long>> lastMessageTimestamp = Optional.empty();
    public volatile Optional<Set<String>> alreadyKilled = Optional.empty();
    private volatile Set<String> cachedOwners = new HashSet<String>();
    private volatile long cachedOwnersTimestamp = Long.MIN_VALUE;

    public long lastApplied() {
        return this.log.getLastEntryIndex();
    }

    public RaftState(String string, RaftStateMachine raftStateMachine, ExecutorService executorService) {
        this(string, new RaftLog(raftStateMachine, Collections.singletonList(string), executorService), -1);
    }

    public RaftState(String string, RaftStateMachine raftStateMachine, int n, ExecutorService executorService) {
        this(string, new RaftLog(raftStateMachine, n >= 0 ? Collections.emptyList() : Collections.singletonList(string), executorService), n);
    }

    public RaftState(String string, RaftStateMachine raftStateMachine, Collection<String> collection, ExecutorService executorService) {
        this(string, new RaftLog(raftStateMachine, collection, executorService), -1);
    }

    public RaftState(String string, RaftLog raftLog, int n) {
        this.serverName = string;
        this.log = raftLog;
        if (!raftLog.logEntries.isEmpty()) {
            this.currentTerm = raftLog.getLastEntryTerm();
        }
        this.targetClusterSize = n;
    }

    public RaftState(String string, RaftLog raftLog) {
        this(string, raftLog, 3);
    }

    public RaftState copy() {
        this.log.assertConsistency();
        RaftState raftState = new RaftState(this.serverName, this.log.copy(), this.targetClusterSize);
        raftState.currentTerm = this.currentTerm;
        raftState.votedFor = this.votedFor;
        raftState.leadership = this.leadership;
        raftState.leader = this.leader;
        raftState.nextIndex = this.nextIndex.map(HashMap::new);
        raftState.matchIndex = this.matchIndex.map(HashMap::new);
        raftState.lastMessageTimestamp = this.lastMessageTimestamp.map(HashMap::new);
        raftState.alreadyKilled = this.alreadyKilled.map(HashSet::new);
        raftState.electionTimeoutCheckpoint = this.electionTimeoutCheckpoint;
        raftState.votesReceived = new HashSet<String>(this.votesReceived);
        return raftState;
    }

    public long commitIndex() {
        return this.log.commitIndex;
    }

    public void bootstrap(boolean bl) {
        this.log.assertConsistency();
        try {
            if (bl || this.targetClusterSize >= 0 && this.log.getQuorumMembers().isEmpty()) {
                this.setCurrentTerm(this.currentTerm + (long)(bl ? 100000 : 1));
                this.log.unsafeBootstrapQuorum(Collections.singleton(this.serverName));
            }
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public void bootstrap() {
        this.bootstrap(false);
    }

    public void setCurrentTerm(long l) {
        this.log.assertConsistency();
        assert (l >= this.currentTerm) : "The term number can never go backwards";
        try {
            if (l > this.currentTerm) {
                this.votesReceived.clear();
                this.votedFor = Optional.empty();
            }
            this.currentTerm = l;
        }
        finally {
            this.log.assertConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observeLifeFrom(String string, long l) {
        this.log.assertConsistency();
        try {
            assert (this.isLeader()) : "Cannot observe signs of life from a follower if we're not the leader!";
            assert (this.lastMessageTimestamp.isPresent()) : "We think we're the leader, but have no lastMessageTimestamp";
            this.lastMessageTimestamp.ifPresent(map -> map.compute(string, (string, l2) -> l));
            this.alreadyKilled.ifPresent(set -> set.remove(string));
            this.nextIndex.ifPresent(map -> map.computeIfAbsent(string, string -> this.log.getLastEntryIndex()));
            this.matchIndex.ifPresent(map -> map.computeIfAbsent(string, string -> 0L));
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public boolean isLeader() {
        this.log.assertConsistency();
        return this.leadership == LeadershipStatus.LEADER;
    }

    public boolean isCandidate() {
        this.log.assertConsistency();
        return this.leadership == LeadershipStatus.CANDIDATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elect(long l) {
        this.log.assertConsistency();
        try {
            assert (this.leadership != LeadershipStatus.LEADER) : "Should not be able to elect if already a leader";
            assert (this.log.getQuorumMembers().contains(this.serverName)) : "Cannot be elected leader if we're not in quorum";
            if (this.leadership != LeadershipStatus.LEADER) {
                this.leadership = LeadershipStatus.LEADER;
                HashMap<String, Long> hashMap = new HashMap<String, Long>(5);
                HashMap<String, Long> hashMap2 = new HashMap<String, Long>(5);
                HashMap<String, Long> hashMap3 = new HashMap<String, Long>(5);
                for (String object2 : this.log.getQuorumMembers()) {
                    if (object2.equals(this.serverName)) continue;
                    hashMap.put(object2, this.log.getLastEntryIndex() + 1L);
                    hashMap2.put(object2, 0L);
                    hashMap3.put(object2, l);
                }
                Set<String> set = this.log.stateMachine.owners();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (string.equals(this.serverName)) continue;
                    hashMap3.put(string, l);
                }
                this.nextIndex = Optional.of(hashMap);
                this.matchIndex = Optional.of(hashMap2);
                this.lastMessageTimestamp = Optional.of(hashMap3);
                this.alreadyKilled = Optional.of(new HashSet());
                this.leader = Optional.of(this.serverName);
            }
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public void stepDownFromElection() {
        this.log.assertConsistency();
        try {
            this.leadership = LeadershipStatus.OTHER;
            if (this.leader.map(string -> string.equals(this.serverName)).orElse(false).booleanValue()) {
                this.leader = Optional.empty();
            }
            this.nextIndex = Optional.empty();
            this.lastMessageTimestamp = Optional.empty();
            this.alreadyKilled = Optional.empty();
            this.matchIndex = Optional.empty();
            this.electionTimeoutCheckpoint = -1L;
            this.votesReceived.clear();
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public void becomeCandidate() {
        this.log.assertConsistency();
        try {
            assert (this.leadership == LeadershipStatus.OTHER) : "Can only become a candidate from a non-candidate, non-leader state";
            assert (this.log.getQuorumMembers().contains(this.serverName)) : "Cannot become a candidate if we are not in the quorum";
            if (this.leadership != LeadershipStatus.OTHER) {
                this.stepDownFromElection();
            }
            if (this.leadership == LeadershipStatus.OTHER) {
                this.leadership = LeadershipStatus.CANDIDATE;
                assert (this.votesReceived.isEmpty()) : "Should not have any votes received when we start an election";
                this.votesReceived.clear();
            }
        }
        finally {
            this.log.assertConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetElectionTimeout(long l, Optional<String> optional) {
        this.log.assertConsistency();
        try {
            if (this.electionTimeoutCheckpoint < 0L || this.electionTimeoutCheckpoint <= l) {
                this.electionTimeoutCheckpoint = l;
                assert (!optional.isPresent() || !optional.get().equals(this.serverName) || this.isLeader() || this.isCandidate()) : "Can only set the leader to ourselves if we're a leader or candidate";
                if (!this.leader.equals(optional)) {
                    this.leader = optional;
                }
            }
        }
        finally {
            this.log.assertConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetElectionTimeout(long l, String string) {
        this.log.assertConsistency();
        try {
            this.resetElectionTimeout(l, Optional.ofNullable(string));
        }
        finally {
            this.log.assertConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldTriggerElection(long l, Span span) {
        this.log.assertConsistency();
        try {
            if (this.electionTimeoutCheckpoint < 0L) {
                this.electionTimeoutCheckpoint = l;
            }
            if (!this.log.getQuorumMembers().contains(this.serverName)) {
                boolean bl = false;
                return bl;
            }
            if (this.isLeader()) {
                boolean bl = false;
                return bl;
            }
            long l2 = (long)this.serverName.hashCode() ^ new Random(this.currentTerm).nextLong();
            long l3 = new SplittableRandom(l2).nextLong(span.begin, span.end);
            boolean bl = l - this.electionTimeoutCheckpoint > l3;
            return bl;
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public void voteFor(String string) {
        this.log.assertConsistency();
        try {
            assert (!this.votedFor.isPresent() || this.votedFor.get().equals(string));
            if (!this.votedFor.isPresent() || this.votedFor.get().equals(string)) {
                this.votedFor = Optional.ofNullable(string);
                if (this.serverName.equals(string)) {
                    this.receiveVoteFrom(this.serverName);
                }
                if (string != null && !string.equals(this.serverName)) {
                    this.leader = Optional.of(string);
                }
            }
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public void receiveVoteFrom(String string) {
        this.log.assertConsistency();
        try {
            if (this.log.getQuorumMembers().contains(string)) {
                this.votesReceived.add(string);
            }
        }
        finally {
            this.log.assertConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftLogEntryLocation transition(Optional<byte[]> optional, Optional<String> optional2) {
        this.log.assertConsistency();
        try {
            assert (this.isLeader()) : "Should only be able to transition as leader.";
            long l = this.log.getLastEntryIndex() + 1L;
            EloquentRaftProto.LogEntry.Builder builder = EloquentRaftProto.LogEntry.newBuilder().setIndex(l).setTerm(this.currentTerm).setType(EloquentRaftProto.LogEntryType.TRANSITION);
            optional.ifPresent(byArray -> builder.setTransition(ByteString.copyFrom((byte[])byArray)));
            optional2.ifPresent(builder::setNewHospiceMember);
            boolean bl = this.log.appendEntries(this.log.getLastEntryIndex(), this.log.getLastEntryTerm(), Collections.singletonList(builder.build()));
            assert (bl) : "Should always be able to add log entries on the leader";
            this.matchIndex.ifPresent(map -> map.put(this.serverName, this.log.getLastEntryIndex()));
            RaftLogEntryLocation raftLogEntryLocation = new RaftLogEntryLocation(l, this.currentTerm);
            return raftLogEntryLocation;
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public RaftLogEntryLocation transition(byte[] byArray) {
        return this.transition(Optional.of(byArray), Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitUpTo(long l, long l2) {
        this.log.assertConsistency();
        try {
            assert (l >= this.commitIndex()) : "Cannot commit backwards!";
            assert (l <= this.log.getLastEntryIndex()) : "Cannot commit beyond current log; commitIndex=" + l + " but last log entry=" + this.log.getLastEntryIndex();
            if (l > this.commitIndex() && l <= this.log.getLastEntryIndex()) {
                this.log.setCommitIndex(l, l2);
            }
        }
        finally {
            this.log.assertConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftLogEntryLocation reconfigure(Collection<String> collection, boolean bl, long l) {
        this.log.assertConsistency();
        try {
            assert (this.isLeader()) : "Can only reconfigure as leader";
            boolean bl2 = this.log.latestQuorumMembers.size() == 1 && this.log.latestQuorumMembers.iterator().next().equals(this.serverName);
            HashSet<String> hashSet = new HashSet<String>(collection);
            hashSet.retainAll(this.log.getQuorumMembers());
            assert (bl || (hashSet.equals(new HashSet<String>(collection)) || hashSet.equals(this.log.getQuorumMembers())) && Math.abs(collection.size() - this.log.getQuorumMembers().size()) == 1) : "We can only add or remove a single server at a time. proposed_config=" + collection + "  current_config=" + this.log.getQuorumMembers() + "  intersection=" + hashSet;
            long l2 = this.log.getLastEntryIndex() + 1L;
            EloquentRaftProto.LogEntry logEntry = EloquentRaftProto.LogEntry.newBuilder().setIndex(l2).setTerm(this.currentTerm).setType(EloquentRaftProto.LogEntryType.CONFIGURATION).addAllConfiguration(collection).build();
            boolean bl3 = this.log.appendEntries(this.log.getLastEntryIndex(), this.log.getLastEntryTerm(), Collections.singletonList(logEntry));
            assert (bl3);
            this.matchIndex.ifPresent(map -> map.put(this.serverName, this.log.getLastEntryIndex()));
            if (bl2 && collection.size() == 0 || collection.size() == 1 && collection.iterator().next().equals(this.serverName)) {
                this.log.setCommitIndex(l2, l);
            }
            for (String string : collection) {
                if (string.equals(this.serverName)) continue;
                this.nextIndex.ifPresent(map -> map.computeIfAbsent(string, string -> this.log.getLastEntryIndex() + 1L));
                this.matchIndex.ifPresent(map -> map.computeIfAbsent(string, string -> 0L));
                this.lastMessageTimestamp.ifPresent(map -> map.computeIfAbsent(string, string -> l));
            }
            RaftLogEntryLocation raftLogEntryLocation = new RaftLogEntryLocation(l2, this.currentTerm);
            return raftLogEntryLocation;
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public RaftLogEntryLocation reconfigure(Collection<String> collection, long l) {
        return this.reconfigure(collection, false, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> serverToAdd(long l, long l2) {
        this.log.assertConsistency();
        try {
            assert (this.isLeader()) : "Only the leader should be adding servers";
            assert (this.lastMessageTimestamp.isPresent()) : "Leader should have a lastMessageTimestamp";
            Set<String> set = this.log.stateMachine.getHospice();
            if (this.targetClusterSize >= 0 && this.log.getQuorumMembers().size() < this.targetClusterSize) {
                Optional<String> optional = this.lastMessageTimestamp.flatMap(map -> {
                    long l3 = 0L;
                    String string = null;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!this.log.getQuorumMembers().contains(entry.getKey()) && !set.contains(entry.getKey()) && (Long)entry.getValue() > l3) {
                            l3 = (Long)entry.getValue();
                            string = (String)entry.getKey();
                            continue;
                        }
                        if (!set.contains(entry.getKey())) continue;
                        System.err.println("node is in the hospice: " + (String)entry.getKey());
                    }
                    if (string != null && !string.equals(this.serverName) && l - l3 < l2) {
                        return Optional.of(string);
                    }
                    return Optional.empty();
                });
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            this.log.assertConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> serverToRemove(long l, long l2) {
        this.log.assertConsistency();
        try {
            assert (this.isLeader()) : "Only the leader should be removing servers";
            assert (this.lastMessageTimestamp.isPresent()) : "Leader should have a lastMessageTimestamp";
            if (this.targetClusterSize >= 0 && this.log.getQuorumMembers().size() > this.targetClusterSize) {
                Optional<String> optional = this.lastMessageTimestamp.flatMap(map -> {
                    long l = Long.MAX_VALUE;
                    String string = null;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!this.log.getQuorumMembers().contains(entry.getKey()) || ((String)entry.getKey()).equals(this.serverName) || (Long)entry.getValue() >= l) continue;
                        l = (Long)entry.getValue();
                        string = (String)entry.getKey();
                    }
                    return Optional.ofNullable(string);
                });
                return optional;
            }
            if (this.targetClusterSize >= 0) {
                Optional<String> optional = this.lastMessageTimestamp.flatMap(map -> {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!this.log.getQuorumMembers().contains(entry.getKey()) || ((String)entry.getKey()).equals(this.serverName) || l - (Long)entry.getValue() <= l2) continue;
                        return Optional.of(entry.getKey());
                    }
                    return Optional.empty();
                });
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            this.log.assertConsistency();
        }
    }

    public Set<String> killNodes(long l, long l2) {
        this.log.assertConsistency();
        assert (this.isLeader()) : "Can only call deadNodes as leader";
        assert (this.lastMessageTimestamp.isPresent()) : "Leader should have a lastMessageTimestamp";
        assert (this.alreadyKilled.isPresent()) : "Leader should have alreadyKilled variable";
        if (this.log.stateMachine instanceof KeyValueStateMachine) {
            return this.lastMessageTimestamp.flatMap(map -> this.alreadyKilled.map(set -> {
                HashSet<String> hashSet = new HashSet<String>();
                if (l > this.cachedOwnersTimestamp + 1000L) {
                    this.cachedOwners = this.log.stateMachine.owners();
                    this.cachedOwnersTimestamp = l;
                }
                for (String string2 : this.cachedOwners) {
                    if (string2.equals(this.serverName) || l - map.computeIfAbsent(string2, string -> l - l2 / 2L) <= l2 || set.contains(string2)) continue;
                    hashSet.add(string2);
                    set.add(string2);
                }
                return hashSet;
            })).orElse(Collections.emptySet());
        }
        return Collections.emptySet();
    }

    public void revive(String string) {
        this.alreadyKilled.ifPresent(set -> set.remove(string));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RaftState raftState = (RaftState)object;
        return this.currentTerm == raftState.currentTerm && Objects.equals(this.serverName, raftState.serverName) && Objects.equals(this.log, raftState.log) && Objects.equals(this.votedFor, raftState.votedFor) && this.leadership == raftState.leadership && Objects.equals(this.leader, raftState.leader) && Objects.equals(this.nextIndex, raftState.nextIndex) && Objects.equals(this.matchIndex, raftState.matchIndex) && Objects.equals(this.electionTimeoutCheckpoint, raftState.electionTimeoutCheckpoint) && Objects.equals(this.votesReceived, raftState.votesReceived) && Objects.equals(this.alreadyKilled, raftState.alreadyKilled) && Objects.equals(this.lastMessageTimestamp, raftState.lastMessageTimestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serverName, this.log, this.currentTerm, this.votedFor, this.leadership, this.nextIndex, this.matchIndex, this.lastMessageTimestamp, this.electionTimeoutCheckpoint, this.votesReceived});
    }

    public static enum LeadershipStatus {
        LEADER,
        CANDIDATE,
        OTHER;

    }
}

