/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.KeyValueStateMachine;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RaftStateMachine {
    private static final Logger log = LoggerFactory.getLogger(KeyValueStateMachine.class);
    private String[] hospice = new String[0];

    public final synchronized Set<String> getHospice() {
        return new HashSet<String>(Arrays.asList(this.hospice));
    }

    protected abstract ByteString serializeImpl();

    public final synchronized byte[] serialize() {
        ByteString byteString = this.serializeImpl();
        return EloquentRaftProto.StateMachine.newBuilder().setPayload(byteString).addAllHospice(Arrays.asList(this.hospice)).build().toByteArray();
    }

    protected abstract void overwriteWithSerializedImpl(byte[] var1, long var2, ExecutorService var4);

    public final synchronized void overwriteWithSerialized(byte[] byArray, long l, ExecutorService executorService) {
        try {
            EloquentRaftProto.StateMachine stateMachine = EloquentRaftProto.StateMachine.parseFrom(byArray);
            this.hospice = (String[])stateMachine.getHospiceList().toArray((Object[])new String[0]);
            this.overwriteWithSerializedImpl(stateMachine.getPayload().toByteArray(), l, executorService);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            log.warn("Could not deserialize state machine; assuming it's in a legacy form");
            this.hospice = new String[0];
            this.overwriteWithSerializedImpl(byArray, l, executorService);
        }
    }

    protected abstract void applyTransition(byte[] var1, long var2, ExecutorService var4);

    final void applyTransition(Optional<byte[]> optional, Optional<String> optional2, long l, ExecutorService executorService) {
        if (optional2.isPresent()) {
            assert (!optional.isPresent()) : "Got both a custom transition and hospice member in transition";
            if (Arrays.stream(this.hospice).noneMatch(string -> string.equals(optional2.get()))) {
                String[] stringArray;
                if (this.hospice.length >= 100) {
                    stringArray = new String[this.hospice.length];
                    System.arraycopy(this.hospice, 1, stringArray, 0, this.hospice.length - 1);
                } else {
                    stringArray = new String[this.hospice.length + 1];
                    System.arraycopy(this.hospice, 0, stringArray, 0, this.hospice.length);
                }
                stringArray[stringArray.length - 1] = optional2.get();
                this.hospice = stringArray;
            }
        } else if (optional.isPresent()) {
            this.applyTransition(optional.get(), l, executorService);
        } else {
            log.error("Got neither a hospice member or a custom transition in state machine transition");
        }
    }

    public String debugTransition(byte[] byArray) {
        return "<no debugging information>";
    }

    public Set<String> owners() {
        return Collections.emptySet();
    }
}

