/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.LocalTransport;
import ai.eloquent.raft.NetRaftTransport;
import ai.eloquent.raft.RaftAlgorithm;
import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.Span;
import ai.eloquent.util.Uninterruptably;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public interface RaftTransport {
    public void bind(RaftAlgorithm var1) throws IOException;

    public Collection<RaftAlgorithm> boundAlgorithms();

    public void rpcTransport(String var1, String var2, EloquentRaftProto.RaftMessage var3, Consumer<EloquentRaftProto.RaftMessage> var4, Runnable var5, long var6);

    public void sendTransport(String var1, String var2, EloquentRaftProto.RaftMessage var3);

    public void broadcastTransport(String var1, EloquentRaftProto.RaftMessage var2);

    public Span expectedNetworkDelay();

    default public void start() {
    }

    default public void stop() {
    }

    default public boolean threadsCanBlock() {
        return false;
    }

    default public long now() {
        return System.currentTimeMillis();
    }

    default public void sleep(long l) {
        Uninterruptably.sleep(l);
    }

    default public void scheduleAtFixedRate(SafeTimerTask safeTimerTask, long l) {
        RaftLifecycle.global.timer.get().scheduleAtFixedRate(safeTimerTask, 0L, l);
    }

    default public void schedule(SafeTimerTask safeTimerTask, long l) {
        RaftLifecycle.global.timer.get().schedule(safeTimerTask, l);
    }

    default public <E> E getFuture(CompletableFuture<E> completableFuture, Duration duration) throws InterruptedException, ExecutionException, TimeoutException {
        return completableFuture.get(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    default public void sendTransport(String string, String string2, Object object) {
        this.sendTransport(string, string2, RaftTransport.mkRaftMessage(string, object));
    }

    default public void broadcastTransport(String string, Object object) {
        this.broadcastTransport(string, RaftTransport.mkRaftMessage(string, object));
    }

    default public void rpcTransport(String string, String string2, Object object, Consumer<EloquentRaftProto.RaftMessage> consumer, Runnable runnable, long l) {
        this.rpcTransport(string, string2, RaftTransport.mkRaftRPC(string, object), consumer, runnable, l);
    }

    default public <E> CompletableFuture<E> rpcTransportAsFuture(String string, String string2, Object object, BiFunction<EloquentRaftProto.RaftMessage, Throwable, E> biFunction, Consumer<Runnable> consumer, long l) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.rpcTransport(string, string2, RaftTransport.mkRaftRPC(string, object), (EloquentRaftProto.RaftMessage raftMessage) -> consumer.accept(() -> completableFuture.complete(biFunction.apply((EloquentRaftProto.RaftMessage)raftMessage, (Throwable)null))), () -> consumer.accept(() -> completableFuture.complete(biFunction.apply(null, new TimeoutException("Timed out RPC from " + string + " to " + string2)))), l);
        return completableFuture;
    }

    default public <E> CompletableFuture<E> rpcTransportAsFuture(String string, String string2, Object object, BiFunction<EloquentRaftProto.RaftMessage, Throwable, E> biFunction, Consumer<Runnable> consumer) {
        return this.rpcTransportAsFuture(string, string2, object, biFunction, consumer, 10000L);
    }

    public static EloquentRaftProto.RaftMessage mkRaftMessage(String string, Object object, boolean bl) {
        if (object instanceof EloquentRaftProto.RaftMessage) {
            return ((EloquentRaftProto.RaftMessage)object).toBuilder().setSender(string).build();
        }
        if (object instanceof EloquentRaftProto.RaftMessage.Builder) {
            return ((EloquentRaftProto.RaftMessage.Builder)object).setSender(string).build();
        }
        EloquentRaftProto.RaftMessage.Builder builder = EloquentRaftProto.RaftMessage.newBuilder().setSender(string).setIsRPC(bl);
        if (object instanceof EloquentRaftProto.AppendEntriesRequest) {
            builder.setAppendEntries((EloquentRaftProto.AppendEntriesRequest)object);
        } else if (object instanceof EloquentRaftProto.InstallSnapshotRequest) {
            builder.setInstallSnapshot((EloquentRaftProto.InstallSnapshotRequest)object);
        } else if (object instanceof EloquentRaftProto.RequestVoteRequest) {
            builder.setRequestVotes((EloquentRaftProto.RequestVoteRequest)object);
        } else if (object instanceof EloquentRaftProto.AddServerRequest) {
            builder.setAddServer((EloquentRaftProto.AddServerRequest)object);
        } else if (object instanceof EloquentRaftProto.RemoveServerRequest) {
            builder.setRemoveServer((EloquentRaftProto.RemoveServerRequest)object);
        } else if (object instanceof EloquentRaftProto.ApplyTransitionRequest) {
            builder.setApplyTransition((EloquentRaftProto.ApplyTransitionRequest)object);
        } else if (object instanceof EloquentRaftProto.AppendEntriesReply) {
            builder.setAppendEntriesReply((EloquentRaftProto.AppendEntriesReply)object);
        } else if (object instanceof EloquentRaftProto.InstallSnapshotReply) {
            builder.setInstallSnapshotReply((EloquentRaftProto.InstallSnapshotReply)object);
        } else if (object instanceof EloquentRaftProto.RequestVoteReply) {
            builder.setRequestVotesReply((EloquentRaftProto.RequestVoteReply)object);
        } else if (object instanceof EloquentRaftProto.AddServerReply) {
            builder.setAddServerReply((EloquentRaftProto.AddServerReply)object);
        } else if (object instanceof EloquentRaftProto.RemoveServerReply) {
            builder.setRemoveServerReply((EloquentRaftProto.RemoveServerReply)object);
        } else if (object instanceof EloquentRaftProto.ApplyTransitionReply) {
            builder.setApplyTransitionReply((EloquentRaftProto.ApplyTransitionReply)object);
        } else {
            throw new IllegalStateException("Unknown request type for an RPC request: " + object.getClass());
        }
        return builder.build();
    }

    public static EloquentRaftProto.RaftMessage mkRaftMessage(String string, Object object) {
        return RaftTransport.mkRaftMessage(string, object, false);
    }

    public static EloquentRaftProto.RaftMessage mkRaftRPC(String string, Object object) {
        return RaftTransport.mkRaftMessage(string, object, true);
    }

    public static RaftTransport create(String string, Type type) throws IOException {
        switch (type) {
            case NET: {
                return new NetRaftTransport(string);
            }
            case LOCAL: {
                return new LocalTransport(true, true);
            }
        }
        throw new IOException("Uncreatable transport type: " + (Object)((Object)type));
    }

    default public String messageType(EloquentRaftProto.RaftMessage raftMessage) {
        if (raftMessage.getAppendEntries() != EloquentRaftProto.AppendEntriesRequest.getDefaultInstance()) {
            return "append_entries";
        }
        if (raftMessage.getRequestVotes() != EloquentRaftProto.RequestVoteRequest.getDefaultInstance()) {
            return "request_votes";
        }
        if (raftMessage.getInstallSnapshot() != EloquentRaftProto.InstallSnapshotRequest.getDefaultInstance()) {
            return "install_snapshot";
        }
        if (raftMessage.getAddServer() != EloquentRaftProto.AddServerRequest.getDefaultInstance()) {
            return "add_server";
        }
        if (raftMessage.getRemoveServer() != EloquentRaftProto.RemoveServerRequest.getDefaultInstance()) {
            return "remove_server";
        }
        if (raftMessage.getApplyTransition() != EloquentRaftProto.ApplyTransitionRequest.getDefaultInstance()) {
            return "apply_transition";
        }
        return "unknown";
    }

    public static enum Type {
        NET,
        LOCAL;

    }
}

