/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.raft.EloquentRaftAlgorithm;
import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.RaftAlgorithm;
import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.raft.RaftState;
import ai.eloquent.raft.RaftStateMachine;
import ai.eloquent.raft.RaftTransport;
import ai.eloquent.util.IdentityHashSet;
import ai.eloquent.util.RuntimeInterruptedException;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.StackTrace;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadedRaftAlgorithm
implements RaftAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(SingleThreadedRaftAlgorithm.class);
    public final RaftAlgorithm impl;
    private final Thread raftThread;
    private Optional<String> taskRunning = Optional.empty();
    private boolean alive = true;
    private final RaftDeque raftTasks = new RaftDeque();
    private final Set<CompletableFuture> waitingForFutures = new IdentityHashSet<CompletableFuture>();
    private final ExecutorService boundaryPool;
    public static final AtomicInteger boundaryPoolThreadsWaiting = new AtomicInteger(0);
    private final boolean threadsCanBlock;

    public SingleThreadedRaftAlgorithm(RaftAlgorithm raftAlgorithm, ExecutorService executorService) {
        this.impl = raftAlgorithm;
        this.threadsCanBlock = raftAlgorithm.getTransport().threadsCanBlock();
        this.raftThread = new Thread(() -> {
            if (raftAlgorithm instanceof EloquentRaftAlgorithm) {
                ((EloquentRaftAlgorithm)raftAlgorithm).setDrivingThread(runnable -> {
                    RaftDeque raftDeque = this.raftTasks;
                    synchronized (raftDeque) {
                        this.raftTasks.offer(new RaftTask("EloquentRaftAlgorithm Callback", TaskPriority.CRITICAL, (Runnable)runnable, throwable -> log.warn("Error in queued task", throwable)));
                        this.raftTasks.notifyAll();
                    }
                });
            }
            try {
                while (this.alive) {
                    try {
                        RaftTask raftTask2;
                        RaftDeque raftDeque = this.raftTasks;
                        synchronized (raftDeque) {
                            this.taskRunning = Optional.empty();
                            this.raftTasks.notifyAll();
                            while (this.raftTasks.isEmpty()) {
                                this.raftTasks.wait(1000L);
                                if (this.alive) continue;
                                return;
                            }
                            raftTask2 = this.raftTasks.poll();
                            this.taskRunning = Optional.of(raftTask2.debugString);
                        }
                        try {
                            raftTask2.fn.run();
                        }
                        catch (Throwable throwable) {
                            raftTask2.onError.accept(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        log.warn("Caught exception ", throwable);
                    }
                }
                return;
            }
            finally {
                RaftDeque raftDeque = this.raftTasks;
                synchronized (raftDeque) {
                    this.raftTasks.forEach(raftTask -> raftTask.onError.accept(new RuntimeException("SingleThreadedRaftAlgorithm main thread killed from killMainThread(), so this will never complete")));
                    this.raftTasks.clear();
                    this.waitingForFutures.forEach(completableFuture -> completableFuture.completeExceptionally(new RuntimeException("SingleThreadedRaftAlgorithm main thread killed from killMainThread(), so this will never complete")));
                    this.waitingForFutures.clear();
                }
            }
        });
        this.raftThread.setPriority(Math.max(1, 8));
        this.raftThread.setDaemon(false);
        this.raftThread.setName("raft-control-" + raftAlgorithm.serverName());
        this.raftThread.setUncaughtExceptionHandler((thread, throwable) -> log.warn("Caught exception on {}:", (Object)thread.getName(), (Object)throwable));
        this.raftThread.start();
        this.boundaryPool = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queuedTaskCount() {
        RaftDeque raftDeque = this.raftTasks;
        synchronized (raftDeque) {
            return this.raftTasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> CompletableFuture<E> execute(String string, TaskPriority taskPriority, Function<RaftAlgorithm, E> function) {
        log.trace("{} - [{}] Executing as Future {}", new Object[]{this.serverName(), this.getTransport().now(), string});
        if (Thread.currentThread() == this.raftThread) {
            return CompletableFuture.completedFuture(function.apply(this.impl));
        }
        if (!this.alive) {
            throw new IllegalStateException("Node is dead -- failing the future");
        }
        CompletableFuture completableFuture = new CompletableFuture();
        Runnable runnable = () -> completableFuture.complete(function.apply(this.impl));
        Consumer<Throwable> consumer = completableFuture::completeExceptionally;
        RaftDeque raftDeque = this.raftTasks;
        synchronized (raftDeque) {
            this.raftTasks.offer(new RaftTask(string, taskPriority, runnable, consumer));
            this.raftTasks.notifyAll();
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> CompletableFuture<E> executeFuture(String string, TaskPriority taskPriority, Function<RaftAlgorithm, CompletableFuture<E>> function) {
        log.trace("{} - [{}] Executing as Composite Future {}", new Object[]{this.serverName(), this.getTransport().now(), string});
        if (!this.alive) {
            throw new IllegalStateException("Node is dead -- failing the future");
        }
        if (Thread.currentThread().getId() == this.raftThread.getId()) {
            return function.apply(this.impl);
        }
        CompletableFuture completableFuture = new CompletableFuture();
        final CompletableFuture completableFuture2 = this.execute(string, taskPriority, function);
        SafeTimerTask safeTimerTask = new SafeTimerTask(){

            @Override
            public void runUnsafe() {
                CompletableFuture completableFuture = completableFuture2.getNow(null);
                if (completableFuture == null) {
                    completableFuture2.completeExceptionally(new TimeoutException("Timed out executeFuture() (never got future)"));
                } else if (!completableFuture.isDone()) {
                    completableFuture.completeExceptionally(new TimeoutException("Timed out executeFuture() (never completed future)"));
                }
            }
        };
        Object object = this.raftTasks;
        synchronized (object) {
            this.waitingForFutures.add(completableFuture2);
        }
        completableFuture2.whenComplete((completableFuture3, throwable) -> this.execute(string, taskPriority, (RaftAlgorithm raftAlgorithm) -> {
            if (Thread.currentThread().getId() != this.raftThread.getId()) {
                log.warn("Future of future should be completing on the Raft control thread; running on {} instead", (Object)Thread.currentThread());
            }
            if (throwable != null) {
                boundaryPoolThreadsWaiting.incrementAndGet();
                this.boundaryPool.submit(() -> {
                    try {
                        completableFuture.completeExceptionally((Throwable)throwable);
                    }
                    finally {
                        boundaryPoolThreadsWaiting.decrementAndGet();
                    }
                });
                return;
            }
            RaftDeque raftDeque = this.raftTasks;
            synchronized (raftDeque) {
                this.waitingForFutures.remove(completableFuture2);
                this.waitingForFutures.add((CompletableFuture)completableFuture3);
            }
            completableFuture3.whenComplete((object, throwable) -> {
                if (throwable == null && Thread.currentThread().getId() != this.raftThread.getId()) {
                    log.warn("Future of future's implementation should be completing on the Raft control thread; running on {} instead", (Object)Thread.currentThread().getId());
                }
                Runnable runnable = safeTimerTask;
                synchronized (runnable) {
                    safeTimerTask.cancel();
                }
                boundaryPoolThreadsWaiting.incrementAndGet();
                runnable = () -> {
                    try {
                        if (object != null) {
                            completableFuture.complete(object);
                        } else if (throwable != null) {
                            completableFuture.completeExceptionally((Throwable)throwable);
                        } else {
                            log.warn("whenComplete() called with a null result and a null exception, this should be impossible!");
                            completableFuture.completeExceptionally(new RuntimeException("This should be impossible!"));
                        }
                    }
                    finally {
                        RaftDeque raftDeque = this.raftTasks;
                        synchronized (raftDeque) {
                            this.waitingForFutures.remove(completableFuture3);
                        }
                        boundaryPoolThreadsWaiting.decrementAndGet();
                    }
                };
                try {
                    this.boundaryPool.submit(runnable);
                }
                catch (Throwable throwable2) {
                    log.error("We got an exception submitting a task to the boundary pool from SingleThreadedRaftAlgorithm. Falling back to a daemon thread.", throwable2);
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.setName("boundary-pool-fallback");
                    thread.setPriority(5);
                    thread.start();
                }
            });
        }));
        try {
            object = safeTimerTask;
            synchronized (object) {
                if (!safeTimerTask.cancelled) {
                    this.getTransport().schedule(safeTimerTask, this.impl.electionTimeoutMillisRange().end + 100L);
                }
            }
        }
        catch (Throwable throwable2) {
            log.warn("Could not schedule timeout future: ", throwable2);
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String string, TaskPriority taskPriority, Consumer<RaftAlgorithm> consumer) {
        log.trace("{} - [{}] Executing {}", new Object[]{this.serverName(), this.getTransport().now(), string});
        if (Thread.currentThread().getId() == this.raftThread.getId()) {
            consumer.accept(this.impl);
            return;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Object object = this.raftTasks;
        synchronized (object) {
            if (!this.alive) {
                log.debug("Node is dead -- ignoring any messages to it");
                return;
            }
            if (!this.raftTasks.offer(new RaftTask(string, taskPriority, () -> {
                try {
                    consumer.accept(this.impl);
                }
                finally {
                    AtomicBoolean atomicBoolean2 = atomicBoolean;
                    synchronized (atomicBoolean2) {
                        atomicBoolean.set(true);
                        atomicBoolean.notifyAll();
                    }
                }
            }, throwable -> {
                log.warn("Got exception running Raft method {}", (Object)string, throwable);
                AtomicBoolean atomicBoolean2 = atomicBoolean;
                synchronized (atomicBoolean2) {
                    atomicBoolean.set(true);
                    atomicBoolean.notifyAll();
                }
            }))) {
                log.warn("Dropping task {} due to size constraints (queue size={})", (Object)string, (Object)this.raftTasks.size());
            }
            this.raftTasks.notifyAll();
        }
        if (this.threadsCanBlock) {
            object = atomicBoolean;
            synchronized (object) {
                if (!atomicBoolean.get()) {
                    try {
                        atomicBoolean.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn("Task seems to be backed up");
                    }
                }
            }
        }
    }

    @Override
    public RaftState state() {
        try {
            return this.execute("state", TaskPriority.LOW, RaftAlgorithm::state).get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            log.warn("Could not get RaftState -- returning unlocked version as a failsafe");
            return this.impl.state();
        }
    }

    @Override
    public RaftState mutableState() {
        return this.impl.mutableState();
    }

    @Override
    public RaftStateMachine mutableStateMachine() {
        return this.impl.mutableStateMachine();
    }

    @Override
    public long term() {
        return this.impl.term();
    }

    @Override
    public String serverName() {
        return this.impl.serverName();
    }

    @Override
    public void broadcastAppendEntries(long l) {
        this.execute("broadcastAppendEntries", TaskPriority.HIGH, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.broadcastAppendEntries(l));
    }

    @Override
    public void sendAppendEntries(String string, long l) {
        this.execute("sendAppendEntries", TaskPriority.HIGH, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.sendAppendEntries(string, l));
    }

    @Override
    public void receiveAppendEntriesRPC(EloquentRaftProto.AppendEntriesRequest appendEntriesRequest, Consumer<EloquentRaftProto.RaftMessage> consumer, long l) {
        this.execute("receiveAppendEntriesRPC", TaskPriority.HIGH, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.receiveAppendEntriesRPC(appendEntriesRequest, consumer, l));
    }

    @Override
    public void receiveAppendEntriesReply(EloquentRaftProto.AppendEntriesReply appendEntriesReply, long l) {
        this.execute("receiveAppendEntriesReply", TaskPriority.HIGH, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.receiveAppendEntriesReply(appendEntriesReply, l));
    }

    @Override
    public void receiveInstallSnapshotRPC(EloquentRaftProto.InstallSnapshotRequest installSnapshotRequest, Consumer<EloquentRaftProto.RaftMessage> consumer, long l) {
        this.execute("receiveInstallSnapshotRPC", TaskPriority.HIGH, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.receiveInstallSnapshotRPC(installSnapshotRequest, consumer, l));
    }

    @Override
    public void receiveInstallSnapshotReply(EloquentRaftProto.InstallSnapshotReply installSnapshotReply, long l) {
        this.execute("receiveInstallSnapshotReply", TaskPriority.HIGH, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.receiveInstallSnapshotReply(installSnapshotReply, l));
    }

    @Override
    public void triggerElection(long l) {
        this.execute("triggerElection", TaskPriority.LOW, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.triggerElection(l));
    }

    @Override
    public void receiveRequestVoteRPC(EloquentRaftProto.RequestVoteRequest requestVoteRequest, Consumer<EloquentRaftProto.RaftMessage> consumer, long l) {
        this.execute("receiveRequestVoteRPC", TaskPriority.CRITICAL, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.receiveRequestVoteRPC(requestVoteRequest, consumer, l));
    }

    @Override
    public void receiveRequestVotesReply(EloquentRaftProto.RequestVoteReply requestVoteReply, long l) {
        this.execute("receiveRequestVotesReply", TaskPriority.CRITICAL, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.receiveRequestVotesReply(requestVoteReply, l));
    }

    @Override
    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveAddServerRPC(EloquentRaftProto.AddServerRequest addServerRequest, long l) {
        return this.executeFuture("receiveAddServerRPC", TaskPriority.LOW, raftAlgorithm -> raftAlgorithm.receiveAddServerRPC(addServerRequest, l));
    }

    @Override
    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveRemoveServerRPC(EloquentRaftProto.RemoveServerRequest removeServerRequest, long l) {
        return this.executeFuture("receciveRemoveServerRPC", TaskPriority.HIGH, raftAlgorithm -> raftAlgorithm.receiveRemoveServerRPC(removeServerRequest, l));
    }

    @Override
    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveApplyTransitionRPC(EloquentRaftProto.ApplyTransitionRequest applyTransitionRequest, long l) {
        return this.executeFuture("receiveApplyTransitionRPC", TaskPriority.LOW, raftAlgorithm -> raftAlgorithm.receiveApplyTransitionRPC(applyTransitionRequest, l));
    }

    @Override
    public boolean bootstrap(boolean bl) {
        try {
            return this.execute("bootstrap", TaskPriority.CRITICAL, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.bootstrap(bl)).get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            log.warn("Could not bootstrap -- returning unlocked version as a failsafe");
            return this.impl.bootstrap(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean bl) {
        this.execute("stop", TaskPriority.LOW, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.stop(bl));
        this.flush(() -> {});
        RaftDeque raftDeque = this.raftTasks;
        synchronized (raftDeque) {
            this.alive = false;
            this.boundaryPool.shutdown();
            this.raftTasks.notifyAll();
            this.waitingForFutures.forEach(completableFuture -> completableFuture.completeExceptionally(new RuntimeException("killMainThread() killed this future")));
        }
    }

    @Override
    public boolean isRunning() {
        try {
            return this.execute("isRunning", TaskPriority.LOW, RaftAlgorithm::isRunning).get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            log.warn("Could not check if Raft is running -- returning unlocked version as a failsafe");
            return this.impl.isRunning();
        }
    }

    @Override
    public void heartbeat(long l) {
        this.execute("heartbeat", TaskPriority.HIGH, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.heartbeat(l));
    }

    @Override
    public void receiveBadRequest(EloquentRaftProto.RaftMessage raftMessage) {
        this.execute("receiveBadRequest", TaskPriority.LOW, (RaftAlgorithm raftAlgorithm) -> raftAlgorithm.receiveBadRequest(raftMessage));
    }

    @Override
    public Optional<RaftLifecycle> lifecycle() {
        return this.impl.lifecycle();
    }

    @Override
    public RaftTransport getTransport() {
        return this.impl.getTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Runnable runnable) {
        boolean bl;
        runnable.run();
        RaftDeque raftDeque = this.raftTasks;
        synchronized (raftDeque) {
            bl = this.raftTasks.isEmpty() && !this.taskRunning.isPresent();
        }
        while (!bl) {
            raftDeque = this.raftTasks;
            synchronized (raftDeque) {
                while (!this.raftTasks.isEmpty()) {
                    try {
                        this.raftTasks.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeInterruptedException(interruptedException);
                    }
                }
            }
            runnable.run();
            raftDeque = this.raftTasks;
            synchronized (raftDeque) {
                bl = this.raftTasks.isEmpty() && !this.taskRunning.isPresent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> errors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.queuedTaskCount();
        if (n > 5) {
            arrayList.add("" + n + " tasks queued on Raft control thread (> threshold of 5). Running task is '" + this.taskRunning.orElse("<unknown>") + "' with a stack trace of:\n" + new StackTrace(this.raftThread.getStackTrace()));
        }
        if (this.impl instanceof EloquentRaftAlgorithm) {
            if (Thread.currentThread().getId() == this.raftThread.getId()) {
                return ((EloquentRaftAlgorithm)this.impl).errors();
            }
            CompletableFuture completableFuture = new CompletableFuture();
            Runnable runnable = () -> completableFuture.complete(((EloquentRaftAlgorithm)this.impl).errors());
            Consumer<Throwable> consumer = completableFuture::completeExceptionally;
            RaftDeque raftDeque = this.raftTasks;
            synchronized (raftDeque) {
                this.raftTasks.offer(new RaftTask("errors", TaskPriority.LOW, runnable, consumer));
                this.raftTasks.notifyAll();
            }
            try {
                arrayList.addAll((Collection)completableFuture.get(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                arrayList.add("Could not get errors from implementing algorithm");
            }
        }
        return arrayList;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stop(true);
    }

    private static class RaftDeque
    implements Deque<RaftTask> {
        private final ArrayDeque<RaftTask> criticalPriority = new ArrayDeque();
        private final ArrayDeque<RaftTask> highPriority = new ArrayDeque();
        private final ArrayDeque<RaftTask> lowPriority = new ArrayDeque();

        private RaftDeque() {
        }

        @Override
        public void addFirst(RaftTask raftTask) {
            switch (raftTask.priority) {
                case CRITICAL: {
                    this.criticalPriority.addFirst(raftTask);
                    break;
                }
                case HIGH: {
                    this.highPriority.addFirst(raftTask);
                    break;
                }
                case LOW: {
                    this.lowPriority.addFirst(raftTask);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled priority " + (Object)((Object)raftTask.priority) + " for task " + raftTask.debugString);
                }
            }
        }

        @Override
        public void addLast(RaftTask raftTask) {
            switch (raftTask.priority) {
                case CRITICAL: {
                    this.criticalPriority.addLast(raftTask);
                    break;
                }
                case HIGH: {
                    this.highPriority.addLast(raftTask);
                    break;
                }
                case LOW: {
                    this.lowPriority.addLast(raftTask);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled priority " + (Object)((Object)raftTask.priority) + " for task " + raftTask.debugString);
                }
            }
        }

        @Override
        public boolean offerFirst(RaftTask raftTask) {
            switch (raftTask.priority) {
                case CRITICAL: {
                    return this.criticalPriority.offerFirst(raftTask);
                }
                case HIGH: {
                    return this.highPriority.offerFirst(raftTask);
                }
                case LOW: {
                    if (this.lowPriority.size() > 10000) {
                        return false;
                    }
                    return this.lowPriority.offerFirst(raftTask);
                }
            }
            throw new IllegalArgumentException("Unhandled priority " + (Object)((Object)raftTask.priority) + " for task " + raftTask.debugString);
        }

        @Override
        public boolean offerLast(RaftTask raftTask) {
            switch (raftTask.priority) {
                case CRITICAL: {
                    return this.criticalPriority.offerLast(raftTask);
                }
                case HIGH: {
                    return this.highPriority.offerLast(raftTask);
                }
                case LOW: {
                    if (this.lowPriority.size() > 10000) {
                        return false;
                    }
                    return this.lowPriority.offerLast(raftTask);
                }
            }
            throw new IllegalArgumentException("Unhandled priority " + (Object)((Object)raftTask.priority) + " for task " + raftTask.debugString);
        }

        @Override
        public RaftTask removeFirst() {
            if (this.criticalPriority.peekFirst() != null) {
                return this.criticalPriority.removeFirst();
            }
            if (this.highPriority.peekFirst() != null) {
                return this.highPriority.removeFirst();
            }
            return this.lowPriority.removeFirst();
        }

        @Override
        public RaftTask removeLast() {
            if (this.criticalPriority.peekLast() != null) {
                return this.criticalPriority.removeLast();
            }
            if (this.highPriority.peekLast() != null) {
                return this.highPriority.removeLast();
            }
            return this.lowPriority.removeLast();
        }

        @Override
        @Nullable
        public RaftTask pollFirst() {
            if (this.criticalPriority.peekFirst() != null) {
                return this.criticalPriority.pollFirst();
            }
            if (this.highPriority.peekFirst() != null) {
                return this.highPriority.pollFirst();
            }
            return this.lowPriority.pollFirst();
        }

        @Override
        @Nullable
        public RaftTask pollLast() {
            if (this.criticalPriority.peekLast() != null) {
                return this.criticalPriority.pollLast();
            }
            if (this.highPriority.peekLast() != null) {
                return this.highPriority.pollLast();
            }
            return this.lowPriority.pollLast();
        }

        @Override
        public RaftTask getFirst() {
            if (this.criticalPriority.peekFirst() != null) {
                return this.criticalPriority.getFirst();
            }
            if (this.highPriority.peekFirst() != null) {
                return this.highPriority.getFirst();
            }
            return this.lowPriority.getFirst();
        }

        @Override
        public RaftTask getLast() {
            if (this.criticalPriority.peekLast() != null) {
                return this.criticalPriority.getLast();
            }
            if (this.highPriority.peekLast() != null) {
                return this.highPriority.getLast();
            }
            return this.lowPriority.getLast();
        }

        @Override
        public RaftTask peekFirst() {
            if (this.criticalPriority.peekFirst() != null) {
                return this.criticalPriority.peekFirst();
            }
            if (this.highPriority.peekFirst() != null) {
                return this.highPriority.peekFirst();
            }
            return this.lowPriority.peekFirst();
        }

        @Override
        public RaftTask peekLast() {
            if (this.criticalPriority.peekLast() != null) {
                return this.criticalPriority.peekLast();
            }
            if (this.highPriority.peekLast() != null) {
                return this.highPriority.peekLast();
            }
            return this.lowPriority.peekLast();
        }

        @Override
        public boolean removeFirstOccurrence(Object object) {
            return this.criticalPriority.removeFirstOccurrence(object) || this.highPriority.removeFirstOccurrence(object) || this.lowPriority.removeFirstOccurrence(object);
        }

        @Override
        public boolean removeLastOccurrence(Object object) {
            return this.lowPriority.removeLastOccurrence(object) || this.highPriority.removeLastOccurrence(object) || this.criticalPriority.removeLastOccurrence(object);
        }

        @Override
        public boolean add(RaftTask raftTask) {
            this.addLast(raftTask);
            return true;
        }

        @Override
        public boolean offer(RaftTask raftTask) {
            return this.offerLast(raftTask);
        }

        @Override
        public RaftTask remove() {
            return this.removeFirst();
        }

        @Override
        public RaftTask poll() {
            return this.pollFirst();
        }

        @Override
        public RaftTask element() {
            return this.getFirst();
        }

        @Override
        public RaftTask peek() {
            return this.peekFirst();
        }

        @Override
        public void push(RaftTask raftTask) {
            this.addFirst(raftTask);
        }

        @Override
        public RaftTask pop() {
            return this.removeFirst();
        }

        @Override
        public boolean remove(Object object) {
            return this.removeFirstOccurrence(object);
        }

        @Override
        public boolean containsAll(@Nonnull Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends RaftTask> collection) {
            for (RaftTask raftTask : collection) {
                this.add(raftTask);
            }
            return true;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> collection) {
            for (Object obj : collection) {
                this.remove(obj);
            }
            return true;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.criticalPriority.clear();
            this.highPriority.clear();
            this.lowPriority.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.criticalPriority.contains(object) || this.highPriority.contains(object) || this.lowPriority.contains(object);
        }

        @Override
        public int size() {
            return this.criticalPriority.size() + this.highPriority.size() + this.lowPriority.size();
        }

        @Override
        public boolean isEmpty() {
            return this.criticalPriority.isEmpty() && this.highPriority.isEmpty() && this.lowPriority.isEmpty();
        }

        @Override
        @Nonnull
        public Iterator<RaftTask> iterator() {
            ArrayDeque<RaftTask> arrayDeque = new ArrayDeque<RaftTask>(this.criticalPriority);
            arrayDeque.addAll(this.highPriority);
            arrayDeque.addAll(this.lowPriority);
            return arrayDeque.iterator();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] TArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public Iterator<RaftTask> descendingIterator() {
            throw new UnsupportedOperationException();
        }
    }

    private static class RaftTask {
        public final Runnable fn;
        public final Consumer<Throwable> onError;
        public final TaskPriority priority;
        public final String debugString;

        private RaftTask(String string, TaskPriority taskPriority, Runnable runnable, Consumer<Throwable> consumer) {
            this.fn = runnable;
            this.onError = consumer;
            this.debugString = string;
            this.priority = taskPriority;
        }
    }

    private static enum TaskPriority {
        CRITICAL,
        HIGH,
        LOW;

    }
}

