/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.error.RaftErrorListener;
import ai.eloquent.raft.EloquentRaftAlgorithm;
import ai.eloquent.raft.EloquentRaftNode;
import ai.eloquent.raft.KeyValueStateMachine;
import ai.eloquent.raft.RaftAlgorithm;
import ai.eloquent.raft.RaftFailsafe;
import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.raft.RaftState;
import ai.eloquent.raft.RaftStateMachine;
import ai.eloquent.raft.RaftTransport;
import ai.eloquent.raft.SingleThreadedRaftAlgorithm;
import ai.eloquent.util.Lazy;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.TimerUtils;
import ai.eloquent.web.TrackedExecutorService;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Theseus {
    private static final Logger log = LoggerFactory.getLogger(Theseus.class);
    public final String serverName;
    public final EloquentRaftNode node;
    final KeyValueStateMachine stateMachine;
    public final RaftLifecycle lifecycle;
    final List<byte[]> unreleasedLocks = new ArrayList<byte[]>();
    private boolean alive = true;
    private final ExecutorService pool;
    private final Duration defaultTimeout;
    private static Lazy<String> defaultServerName = Lazy.of(() -> {
        String string;
        try {
            string = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException unknownHostException) {
            log.warn("Could not get InetAddress.getLocalHost() in order to determine Theseus' hostname", (Throwable)unknownHostException);
            Optional<String> optional = Optional.ofNullable(System.getenv("HOST"));
            string = optional.orElseGet(() -> UUID.randomUUID().toString());
        }
        if (string.contains("/")) {
            string = string.substring(string.indexOf(47) + 1);
        }
        string = string + "_" + System.currentTimeMillis();
        return string;
    });

    public Theseus(RaftAlgorithm raftAlgorithm, RaftTransport raftTransport, RaftLifecycle raftLifecycle) {
        this.serverName = raftAlgorithm.serverName();
        this.node = new EloquentRaftNode(raftAlgorithm, raftTransport, raftLifecycle);
        this.node.registerShutdownHook(() -> {
            this.alive = false;
            List<byte[]> list = this.unreleasedLocks;
            synchronized (list) {
                this.unreleasedLocks.notifyAll();
            }
        });
        this.defaultTimeout = Duration.ofMillis(this.node.algorithm.electionTimeoutMillisRange().end * 2L);
        this.stateMachine = (KeyValueStateMachine)raftAlgorithm.mutableStateMachine();
        this.lifecycle = raftLifecycle;
        this.pool = raftLifecycle.managedThreadPool("eloquent-raft-async", true);
        Thread thread = new Thread(() -> {
            while (this.alive) {
                try {
                    byte[][] byArray;
                    Object object = this.unreleasedLocks;
                    synchronized (object) {
                        while (this.unreleasedLocks.isEmpty() && this.alive) {
                            try {
                                this.unreleasedLocks.wait(this.node.algorithm.electionTimeoutMillisRange().end * 2L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        byArray = (byte[][])this.unreleasedLocks.toArray((T[])new byte[0][]);
                    }
                    if (byArray.length <= 0 || this.alive && !this.errors().isEmpty() || !this.node.algorithm.mutableState().leader.isPresent()) continue;
                    log.warn("Trying to release {} unreleased locks", (Object)byArray.length);
                    object = KeyValueStateMachine.createGroupedTransition(byArray);
                    Boolean bl = this.node.submitTransition((byte[])object).get(this.node.algorithm.electionTimeoutMillisRange().end + 100L, TimeUnit.MILLISECONDS);
                    if (bl != null && bl.booleanValue()) {
                        log.warn("Successfully released {} unreleased locks", (Object)byArray.length);
                        List<byte[]> list = this.unreleasedLocks;
                        synchronized (list) {
                            this.unreleasedLocks.removeAll(Arrays.asList(byArray));
                            continue;
                        }
                    }
                    log.warn("Could not release {} locks; retrying later.", (Object)byArray.length);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof TimeoutException || throwable instanceof CompletionException && throwable.getCause() != null && throwable.getCause() instanceof TimeoutException) {
                        log.info("Caught a timeout exception in the lockCleanupThread in Theseus");
                        continue;
                    }
                    log.warn("Caught an exception in the lockCleanupThread in Theseus", throwable);
                }
            }
        });
        thread.setName("raft-lock-cleanup");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    public Theseus(String string, RaftTransport raftTransport, int n, RaftLifecycle raftLifecycle) {
        this(new SingleThreadedRaftAlgorithm(new EloquentRaftAlgorithm(string, (RaftStateMachine)new KeyValueStateMachine(string), raftTransport, n, raftLifecycle.managedThreadPool("raft-public", true), Optional.of(raftLifecycle)), raftLifecycle.managedThreadPool("raft-pubic", true)), raftTransport, raftLifecycle);
    }

    public Theseus(String string, RaftTransport raftTransport, Collection<String> collection, RaftLifecycle raftLifecycle) {
        this(new SingleThreadedRaftAlgorithm(new EloquentRaftAlgorithm(string, (RaftStateMachine)new KeyValueStateMachine(string), raftTransport, collection, raftLifecycle.managedThreadPool("raft-public", true), Optional.of(raftLifecycle)), raftLifecycle.managedThreadPool("raft-pubic", true)), raftTransport, raftLifecycle);
    }

    public Theseus(String string, Collection<String> collection) throws IOException {
        this(string, RaftTransport.create(string, RaftTransport.Type.NET), collection, RaftLifecycle.global);
    }

    public Theseus(int n) throws IOException {
        this(defaultServerName.get(), RaftTransport.create(defaultServerName.get(), RaftTransport.Type.NET), n, RaftLifecycle.global);
    }

    public void close() {
        this.node.close();
    }

    void start() {
        this.node.start();
    }

    public boolean bootstrap(boolean bl) {
        log.info("Bootstrapping Raft");
        return this.node.bootstrap(bl);
    }

    public boolean bootstrap() {
        return this.bootstrap(false);
    }

    public RaftState state() {
        return this.node.algorithm.state();
    }

    public List<String> errors() {
        return this.node.errors();
    }

    public CompletableFuture<Boolean> withDistributedLockAsync(String string, Runnable runnable) {
        return this.withDistributedLockAsync(string, () -> CompletableFuture.supplyAsync(() -> {
            try {
                runnable.run();
                return true;
            }
            catch (Throwable throwable) {
                log.warn("Caught exception on withDistributedLockAsync ", throwable);
                return false;
            }
        }, this.pool));
    }

    public CompletableFuture<Boolean> withDistributedLockAsync(String string, Supplier<CompletableFuture<Boolean>> supplier) {
        String string2 = UUID.randomUUID().toString();
        byte[] byArray = KeyValueStateMachine.createReleaseLockTransition(string, this.serverName, string2);
        return this.retryTransitionAsync(KeyValueStateMachine.createRequestLockTransition(string, this.serverName, string2), this.defaultTimeout).thenCompose(bl3 -> {
            if (!bl3.booleanValue()) {
                return this.node.submitTransition(byArray).whenComplete((bl, throwable) -> this.handleReleaseLockResult((Boolean)bl, (Throwable)throwable, byArray));
            }
            return ((CompletableFuture)this.stateMachine.createLockAcquiredFuture(string, this.serverName, string2).thenCompose(arg_0 -> Theseus.lambda$null$7((Supplier)supplier, arg_0))).whenComplete((bl2, throwable2) -> this.node.submitTransition(byArray).whenComplete((bl, throwable) -> this.handleReleaseLockResult((Boolean)bl, (Throwable)throwable, byArray)));
        });
    }

    public Optional<LongLivedLock> tryLock(String string, Duration duration) {
        try {
            return this.tryLockAsync(string, duration).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return Optional.empty();
        }
    }

    public CompletableFuture<Optional<LongLivedLock>> tryLockAsync(String string, Duration duration) {
        String string2 = Long.toHexString(new Random().nextLong());
        CompletableFuture<Optional<LongLivedLock>> completableFuture = new CompletableFuture<Optional<LongLivedLock>>();
        this.retryTransitionAsync(KeyValueStateMachine.createTryLockTransition(string, this.serverName, string2), this.defaultTimeout).thenAccept(bl2 -> {
            try {
                if (this.stateMachine.locks.containsKey(string) && this.stateMachine.locks.get((Object)string).holder.map(lockRequest -> lockRequest.server.equals(this.serverName) && lockRequest.uniqueHash.equals(string2)).orElse(false).booleanValue()) {
                    completableFuture.complete(Optional.of(new LongLivedLockImpl(string, string2, duration)));
                } else {
                    completableFuture.complete(Optional.empty());
                }
            }
            catch (Throwable throwable2) {
                byte[] byArray = KeyValueStateMachine.createReleaseLockTransition(string, this.serverName, string2);
                this.node.submitTransition(byArray).whenComplete((bl, throwable) -> {
                    this.handleReleaseLockResult((Boolean)bl, (Throwable)throwable, byArray);
                    completableFuture.complete(Optional.empty());
                });
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Boolean> releaseLock(String string) {
        KeyValueStateMachine.QueueLock queueLock = this.stateMachine.locks.get(string);
        if (queueLock != null && queueLock.holder.isPresent()) {
            KeyValueStateMachine.LockRequest lockRequest = queueLock.holder.get();
            return this.retryTransitionAsync(KeyValueStateMachine.createReleaseLockTransition(string, lockRequest.server, lockRequest.uniqueHash), this.defaultTimeout);
        }
        return CompletableFuture.completedFuture(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueFailedLock(byte[] byArray) {
        List<byte[]> list = this.unreleasedLocks;
        synchronized (list) {
            if (this.unreleasedLocks.size() < 0x100000) {
                log.warn("Could not release lock! Queueing for later deletion.");
                boolean bl = false;
                for (byte[] byArray2 : this.unreleasedLocks) {
                    if (!Arrays.equals(byArray2, byArray)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.unreleasedLocks.add(byArray);
                }
            } else {
                log.error("Could not release a lock and did not queue it for later deletion (queue full)");
            }
        }
    }

    private void handleReleaseLockResult(Boolean bl, Throwable throwable, byte[] byArray) {
        if (throwable != null || bl == null || !bl.booleanValue()) {
            if (!(throwable == null || throwable instanceof TimeoutException || throwable instanceof CompletionException && throwable.getCause() != null && throwable.getCause() instanceof TimeoutException)) {
                log.warn("Release lock encountered an unexpected error: ", throwable);
            }
            this.queueFailedLock(byArray);
        }
    }

    public CompletableFuture<Boolean> withElementAsync(String string, Function<byte[], byte[]> function, @Nullable Supplier<byte[]> supplier, boolean bl) {
        String string2 = UUID.randomUUID().toString();
        byte[] byArray = KeyValueStateMachine.createRequestLockTransition(string, this.serverName, string2);
        byte[] byArray2 = KeyValueStateMachine.createReleaseLockTransition(string, this.serverName, string2);
        Supplier<CompletableFuture> supplier2 = () -> this.node.submitTransition(byArray2).whenComplete((bl, throwable) -> this.handleReleaseLockResult((Boolean)bl, (Throwable)throwable, byArray2));
        return Theseus.exceptionProof(this.retryTransitionAsync(byArray, this.defaultTimeout)).thenCompose(bl2 -> {
            if (!bl2.booleanValue()) {
                return (CompletionStage)supplier2.get();
            }
            return this.stateMachine.createLockAcquiredFuture(string, this.serverName, string2).thenCompose(arg_0 -> this.lambda$null$18(string, (Supplier)supplier, (Supplier)supplier2, function, bl, byArray2, arg_0));
        });
    }

    public CompletableFuture<Boolean> withElementUnlockedAsync(String string, Function<byte[], byte[]> function, @Nullable Supplier<byte[]> supplier, boolean bl) {
        Optional<byte[]> optional = this.stateMachine.get(string, this.node.transport.now());
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.pool.execute(() -> {
            byte[] byArray;
            boolean bl3 = false;
            if (optional.isPresent()) {
                byArray = (byte[])optional.get();
            } else if (supplier != null) {
                try {
                    byArray = (byte[])supplier.get();
                    bl3 = true;
                }
                catch (Throwable throwable2) {
                    log.warn("withElementAsync() object creator threw an exception. Returning failure");
                    completableFuture.complete(false);
                    return;
                }
            } else {
                log.warn("withElementAsync() object creator is null and there's nothing in the map. Returning failure");
                completableFuture.complete(false);
                return;
            }
            if (byArray == null) {
                completableFuture.complete(false);
                return;
            }
            byte[] byArray2 = (byte[])function.apply(byArray);
            if (bl3 || byArray2 != null && !Arrays.equals(byArray, byArray2)) {
                this.retryTransitionAsync(this.createSetValueTransition(string, byArray2, bl), this.defaultTimeout).whenComplete((bl, throwable) -> {
                    if (throwable != null) {
                        completableFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        completableFuture.complete((Boolean)bl);
                    }
                });
            } else {
                completableFuture.complete(true);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Boolean> setElementAsync(String string, byte[] byArray, boolean bl, Duration duration) {
        return this.retryTransitionAsync(this.createSetValueTransition(string, byArray, bl), duration);
    }

    private byte[] createSetValueTransition(String string, byte[] byArray, boolean bl) {
        if (bl) {
            return KeyValueStateMachine.createSetValueTransition(string, byArray);
        }
        return KeyValueStateMachine.createSetValueTransitionWithOwner(string, byArray, this.serverName);
    }

    public CompletableFuture<Boolean> removeElementAsync(String string, Duration duration) {
        return this.retryTransitionAsync(KeyValueStateMachine.createRemoveValueTransition(string), duration);
    }

    public CompletableFuture<Boolean> removeElementsAsync(Set<String> set, Duration duration) {
        return this.retryTransitionAsync(KeyValueStateMachine.createGroupedTransition((byte[][])set.stream().map(KeyValueStateMachine::createRemoveValueTransition).collect(Collectors.toList()).toArray((T[])new byte[set.size()][])), duration);
    }

    public Optional<byte[]> getElement(String string) {
        return this.stateMachine.get(string, this.node.transport.now());
    }

    public Set<String> getConfiguration() {
        return this.node.algorithm.mutableState().log.getQuorumMembers();
    }

    public Map<String, byte[]> getMap() {
        return this.stateMachine.map();
    }

    public Collection<String> getKeys() {
        return this.stateMachine.keys();
    }

    public Map<String, String> getLocks() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, KeyValueStateMachine.QueueLock> entry : this.stateMachine.locks.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().holder.map(lockRequest -> lockRequest.server).orElse("<none>"));
        }
        return hashMap;
    }

    public synchronized void addChangeListener(KeyValueStateMachine.ChangeListener changeListener) {
        this.stateMachine.addChangeListener(changeListener);
    }

    public synchronized void removeChangeListener(KeyValueStateMachine.ChangeListener changeListener) {
        this.stateMachine.removeChangeListener(changeListener);
    }

    public void addErrorListener(RaftErrorListener raftErrorListener) {
        this.stateMachine.addErrorListener(raftErrorListener);
        this.node.addErrorListener(raftErrorListener);
        if (this.pool instanceof TrackedExecutorService) {
            ((TrackedExecutorService)this.pool).addErrorListener(raftErrorListener);
        }
    }

    public void removeErrorListener(RaftErrorListener raftErrorListener) {
        this.stateMachine.removeErrorListener(raftErrorListener);
        this.node.removeErrorListener(raftErrorListener);
        if (this.pool instanceof TrackedExecutorService) {
            ((TrackedExecutorService)this.pool).removeErrorListener(raftErrorListener);
        }
    }

    public void clearErrorListeners() {
        this.stateMachine.clearErrorListeners();
        this.node.clearErrorListeners();
        if (this.pool instanceof TrackedExecutorService) {
            ((TrackedExecutorService)this.pool).clearErrorListeners();
        }
    }

    private CompletableFuture<Boolean> retryTransitionAsync(byte[] byArray, Duration duration) {
        int n = new Random().nextInt();
        long l = System.currentTimeMillis();
        log.trace("\n-------------\nSTARTING TRANSITION {}\n-------------\n", (Object)n);
        return this.retryAsync(() -> this.node.submitTransition(byArray), duration).thenApply(bl -> {
            log.trace("\n-------------\nFINISHED TRANSITION {}: {} ({})\n-------------\n", new Object[]{n, bl, TimerUtils.formatTimeSince(l)});
            return bl;
        });
    }

    private static CompletableFuture<Boolean> exceptionProof(CompletableFuture<Boolean> completableFuture) {
        CompletableFuture<Boolean> completableFuture2 = new CompletableFuture<Boolean>();
        completableFuture.whenComplete((bl, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof TimeoutException || throwable instanceof CompletionException && throwable.getCause() != null && throwable.getCause() instanceof TimeoutException) {
                    log.info("Caught a timeout exception exception proof wrapper");
                } else {
                    log.warn("Caught an exception in exception proof wrapper", throwable);
                }
                completableFuture2.complete(false);
            } else {
                completableFuture2.complete((Boolean)bl);
            }
        });
        return completableFuture2;
    }

    private CompletableFuture<Boolean> retryAsync(final Supplier<CompletableFuture<Boolean>> supplier, Duration duration) {
        long l = this.node.transport.now();
        CompletableFuture<Boolean> completableFuture = Theseus.exceptionProof(supplier.get());
        return completableFuture.thenCompose(bl -> {
            if (bl.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            log.warn("Retrying a failed transition @ {} - this is fine, but should be rare", (Object)this.node.transport.now());
            long l2 = this.node.transport.now() - l;
            final long l3 = duration.toMillis() - l2;
            if (l3 < 0L || !this.node.isAlive()) {
                return CompletableFuture.completedFuture(false);
            }
            final CompletableFuture completableFuture = new CompletableFuture();
            this.node.transport.schedule(new SafeTimerTask(){

                @Override
                public void runUnsafe() {
                    Theseus.this.retryAsync(supplier, Duration.ofMillis(l3)).thenApply(completableFuture::complete);
                }
            }, this.node.algorithm.electionTimeoutMillisRange().begin / 5L);
            return completableFuture;
        });
    }

    public boolean isLeader() {
        return this.node.algorithm.mutableState().isLeader();
    }

    public void registerFailsafe(RaftFailsafe raftFailsafe) {
        this.node.registerFailsafe(raftFailsafe);
    }

    private /* synthetic */ CompletionStage lambda$null$18(String string, @Nullable Supplier supplier, Supplier supplier2, Function function, boolean bl, byte[] byArray, Boolean bl2) {
        if (bl2.booleanValue()) {
            try {
                Optional<byte[]> optional = this.stateMachine.get(string, this.node.transport.now());
                CompletableFuture completableFuture = new CompletableFuture();
                this.pool.execute(() -> this.lambda$null$17(optional, (Supplier)supplier, (Supplier)supplier2, completableFuture, function, string, bl, byArray));
                return completableFuture;
            }
            catch (Throwable throwable) {
                log.warn("Uncaught exception when mutating element in withElementAsync: ", throwable);
                return (CompletionStage)supplier2.get();
            }
        }
        return (CompletionStage)supplier2.get();
    }

    private /* synthetic */ void lambda$null$17(Optional optional, @Nullable Supplier supplier, Supplier supplier2, CompletableFuture completableFuture, Function function, String string, boolean bl, byte[] byArray) {
        byte[] byArray2;
        byte[] byArray3;
        boolean bl2 = false;
        if (optional.isPresent()) {
            byArray3 = (byte[])optional.get();
        } else if (supplier != null) {
            try {
                byArray3 = (byte[])supplier.get();
                bl2 = true;
            }
            catch (Throwable throwable) {
                log.warn("withElementAsync() object creator threw an exception. Returning failure");
                ((CompletableFuture)supplier2.get()).thenAccept(completableFuture::complete);
                return;
            }
        } else {
            log.warn("withElementAsync() object creator is null and there's nothing in the map. Returning failure");
            ((CompletableFuture)supplier2.get()).thenAccept(completableFuture::complete);
            return;
        }
        if (byArray3 == null) {
            ((CompletableFuture)supplier2.get()).thenAccept(completableFuture::complete);
            return;
        }
        try {
            byArray2 = (byte[])function.apply(byArray3);
        }
        catch (Throwable throwable) {
            ((CompletableFuture)supplier2.get()).thenAccept(completableFuture::complete);
            return;
        }
        if (bl2 || byArray2 != null && !Arrays.equals(byArray3, byArray2)) {
            this.retryTransitionAsync(KeyValueStateMachine.createGroupedTransition(this.createSetValueTransition(string, byArray2, bl), byArray), this.defaultTimeout).whenComplete((arg_0, arg_1) -> Theseus.lambda$null$16((Supplier)supplier2, completableFuture, arg_0, arg_1));
        } else {
            ((CompletableFuture)supplier2.get()).thenAccept(completableFuture::complete);
        }
    }

    private static /* synthetic */ void lambda$null$16(Supplier supplier, CompletableFuture completableFuture, Boolean bl, Throwable throwable) {
        if (bl == null || !bl.booleanValue()) {
            log.warn("Could not apply transition and/or release object lock: ", throwable);
            ((CompletableFuture)supplier.get()).thenAccept(completableFuture::complete);
        } else {
            completableFuture.complete(true);
        }
    }

    private static /* synthetic */ CompletionStage lambda$null$7(Supplier supplier, Boolean bl) {
        if (bl.booleanValue()) {
            try {
                return (CompletionStage)supplier.get();
            }
            catch (Throwable throwable) {
                log.warn("Uncaught exception on runnable in withDistributedLockAsync: ", throwable);
                return CompletableFuture.completedFuture(false);
            }
        }
        return CompletableFuture.completedFuture(false);
    }

    private static class LockCleanupTimerTask
    extends SafeTimerTask {
        WeakReference<LongLivedLock> weakLock;

        public LockCleanupTimerTask(LongLivedLock longLivedLock) {
            this.weakLock = new WeakReference<LongLivedLock>(longLivedLock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runUnsafe() {
            LongLivedLock longLivedLock = (LongLivedLock)this.weakLock.get();
            if (longLivedLock == null) {
                return;
            }
            if (longLivedLock.isCertainlyHeld()) {
                LongLivedLock longLivedLock2 = longLivedLock;
                synchronized (longLivedLock2) {
                    if (longLivedLock.isCertainlyHeld()) {
                        log.warn("LongLivedLock for \"{}\" is being cleaned up from a TimerTask! This is very, very bad! It means we didn't release it, and finalize() never fired.", (Object)longLivedLock.lockName());
                        longLivedLock.release();
                    }
                }
            }
        }
    }

    private class LongLivedLockImpl
    implements LongLivedLock {
        public final String lockName;
        public final String uniqueHash;
        public final Duration safetyReleaseWindow;
        private boolean held = true;
        private boolean wantToHold = true;
        public final SafeTimerTask cleanupTimerTask;

        protected LongLivedLockImpl(String string, String string2, Duration duration) {
            this.lockName = string;
            this.uniqueHash = string2;
            this.safetyReleaseWindow = duration;
            this.cleanupTimerTask = new LockCleanupTimerTask(this);
            Theseus.this.node.transport.schedule(this.cleanupTimerTask, duration.toMillis());
        }

        @Override
        public String lockName() {
            return this.lockName;
        }

        @Override
        public boolean isCertainlyHeld() {
            return this.held && this.wantToHold;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPerhapsHeld() {
            if (!this.held) {
                return false;
            }
            if (this.wantToHold) {
                return true;
            }
            KeyValueStateMachine.QueueLock queueLock = Theseus.this.stateMachine.locks.get(this.lockName);
            if (queueLock == null || !queueLock.holder.isPresent()) {
                LongLivedLockImpl longLivedLockImpl = this;
                synchronized (longLivedLockImpl) {
                    this.held = false;
                }
            }
            KeyValueStateMachine.LockRequest lockRequest = queueLock.holder.get();
            LongLivedLockImpl longLivedLockImpl = this;
            synchronized (longLivedLockImpl) {
                this.held = lockRequest.server.equals(Theseus.this.serverName) && lockRequest.uniqueHash.equals(this.uniqueHash);
            }
            return this.held;
        }

        @Override
        public synchronized CompletableFuture<Boolean> release() {
            if (!this.wantToHold) {
                if (this.held) {
                    log.warn("Double-releasing a lock will have no effect. We see that this lock is currently perhaps held; the only recourse is to wait for the failsafe to release the lock.");
                }
                return CompletableFuture.completedFuture(!this.held);
            }
            this.wantToHold = false;
            this.cleanupTimerTask.cancel();
            byte[] byArray = KeyValueStateMachine.createReleaseLockTransition(this.lockName, Theseus.this.serverName, this.uniqueHash);
            return Theseus.this.node.submitTransition(byArray).whenComplete((bl, throwable) -> Theseus.this.handleReleaseLockResult(bl, throwable, byArray));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                super.finalize();
            }
            finally {
                if (this.held) {
                    log.warn("{} - LongLivedLock for \"{}\" is being cleaned up from finalize()! This is very bad!", (Object)Theseus.this.serverName, (Object)this.lockName);
                    Object object = Theseus.this.unreleasedLocks;
                    synchronized (object) {
                        Theseus.this.queueFailedLock(KeyValueStateMachine.createReleaseLockTransition(this.lockName, Theseus.this.serverName, this.uniqueHash));
                    }
                    object = this;
                    synchronized (object) {
                        if (this.held) {
                            this.release();
                        }
                    }
                }
            }
        }
    }

    public static interface LongLivedLock
    extends AutoCloseable {
        public String lockName();

        public boolean isCertainlyHeld();

        public boolean isPerhapsHeld();

        public CompletableFuture<Boolean> release();

        @Override
        default public void close() throws Exception {
            this.release().get();
        }
    }
}

