/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.data.UDPTransport;
import ai.eloquent.raft.RaftAlgorithm;
import ai.eloquent.raft.RaftFailsafe;
import ai.eloquent.raft.RaftState;
import ai.eloquent.util.IOSupplier;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsatisfiableQuorumFailsafe
implements RaftFailsafe {
    private static final Logger log = LoggerFactory.getLogger(UnsatisfiableQuorumFailsafe.class);
    private final IOSupplier<String[]> getClusterState;
    public final long timeout;

    public UnsatisfiableQuorumFailsafe(Duration duration) {
        this(() -> {
            InetAddress[] inetAddressArray = UDPTransport.readKubernetesState();
            String[] stringArray = new String[inetAddressArray.length];
            for (int i = 0; i < inetAddressArray.length; ++i) {
                stringArray[i] = inetAddressArray[i].getHostAddress();
            }
            return stringArray;
        }, duration);
    }

    public UnsatisfiableQuorumFailsafe(IOSupplier<String[]> iOSupplier, Duration duration) {
        this.getClusterState = iOSupplier;
        this.timeout = duration.toMillis();
    }

    @Override
    public void heartbeat(RaftAlgorithm raftAlgorithm, long l) {
        RaftState raftState = raftAlgorithm.mutableState();
        if (raftState.isLeader()) {
            raftState.lastMessageTimestamp.ifPresent(map -> {
                if (map.isEmpty()) {
                    return;
                }
                for (Object object : map.keySet()) {
                    long l2 = l - (Long)map.get(object);
                    if (l2 > this.timeout) continue;
                    return;
                }
                try {
                    String[] stringArray = this.getClusterState.get();
                    for (String string : map.keySet()) {
                        if (string.equalsIgnoreCase(raftAlgorithm.serverName())) continue;
                        for (String string2 : stringArray) {
                            if (!string.equals(string2)) continue;
                            return;
                        }
                    }
                }
                catch (IOException iOException) {
                    log.warn("Could not get Kubernetes state -- ignoring failsafe! ", (Throwable)iOException);
                    return;
                }
                log.warn("UNSATISFIABLE QUORUM FAILSAFE TRIGGERED! This means we detected a deadlock or split brain in Raft, where all the other boxes that are part of the cluster are now dead. This is obviously bad, and should never happen. We're now going to attempt to recover automatically, but the root cause should be investigated (probably that boxes are not respecting their shutdown locks). Good luck.");
                raftState.reconfigure(Collections.singleton(raftAlgorithm.serverName()), true, l);
            });
        }
    }
}

