/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyUtils {
    private static final Logger log = LoggerFactory.getLogger(ConcurrencyUtils.class);
    private static ThreadMXBean threadmx = ManagementFactory.getThreadMXBean();

    private ConcurrencyUtils() {
    }

    public static boolean ensureLockOrder(List<Object> list, Object object) {
        if (list.isEmpty()) {
            return true;
        }
        int n = list.indexOf(object);
        assert (n >= 0 && n < list.size()) : "Could not find lock in lock order: " + object;
        if (n < 0 || n >= list.size()) {
            return false;
        }
        if (object instanceof ReentrantLock && ((ReentrantLock)object).isHeldByCurrentThread()) {
            return true;
        }
        for (int i = n + 1; i < list.size(); ++i) {
            Object object2 = list.get(i);
            if (object2 instanceof ReentrantLock) {
                assert (!((ReentrantLock)object2).isHeldByCurrentThread()) : "Trying to take lock " + object + " (index " + n + ") but already hold later lock " + object2 + " (index " + i + ")";
                if (((ReentrantLock)object2).isHeldByCurrentThread()) {
                    return false;
                }
                assert (!Thread.holdsLock(object2)) : "Trying to take lock " + object + " (index " + n + " ) but already hold later lock " + object2 + " (index " + i + ")";
                if (!Thread.holdsLock(object2)) continue;
                return false;
            }
            assert (!Thread.holdsLock(object2)) : "Trying to take lock " + object + " (index " + n + ") but already hold later lock " + object2 + " (index " + i + ")";
            if (!Thread.holdsLock(object2)) continue;
            return false;
        }
        return true;
    }

    public static boolean ensureNoLocksHeld(Collection<Object> collection) {
        for (Object object : collection) {
            if (object instanceof ReentrantLock) {
                assert (!((ReentrantLock)object).isHeldByCurrentThread()) : "Lock " + object + " is held by the current thread ( " + Thread.currentThread() + ")";
                if (((ReentrantLock)object).isHeldByCurrentThread()) {
                    return false;
                }
                assert (!Thread.holdsLock(object)) : "Lock " + object + " is held by the current thread ( " + Thread.currentThread() + ")";
                if (!Thread.holdsLock(object)) continue;
                return false;
            }
            assert (!Thread.holdsLock(object)) : "Lock " + object + " is held by the current thread ( " + Thread.currentThread() + ")";
            if (!Thread.holdsLock(object)) continue;
            return false;
        }
        return true;
    }

    public static boolean ensureNoLocksHeld() {
        ThreadInfo threadInfo = threadmx.getThreadInfo(new long[]{Thread.currentThread().getId()}, true, false)[0];
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        assert (monitorInfoArray.length == 0) : "Thread holds " + monitorInfoArray.length + " monitor locks (first is " + monitorInfoArray[0].getClassName() + ")";
        LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
        assert (lockInfoArray.length == 0) : "Thread holds " + lockInfoArray.length + " synchronizers (first is " + lockInfoArray[0].getClassName() + ")";
        return lockInfoArray.length == 0 && monitorInfoArray.length == 0;
    }

    public static boolean ensureLocksHeld(Collection<Object> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        for (Object object : collection) {
            if (object instanceof ReentrantLock) {
                assert (((ReentrantLock)object).isHeldByCurrentThread()) : "Lock " + object + " is not held by the current thread ( " + Thread.currentThread() + ")";
                if (!((ReentrantLock)object).isHeldByCurrentThread()) {
                    return false;
                }
                assert (Thread.holdsLock(object)) : "Lock " + object + " is not held by the current thread ( " + Thread.currentThread() + ")";
                if (Thread.holdsLock(object)) continue;
                return false;
            }
            assert (Thread.holdsLock(object)) : "Lock " + object + " is not held by the current thread ( " + Thread.currentThread() + ")";
            if (Thread.holdsLock(object)) continue;
            return false;
        }
        return true;
    }
}

