/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import ai.eloquent.util.ThrowableSupplier;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionalUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionalUtils.class);

    public static <K, V> ConcurrentHashMap<K, V> emptyConcurrentMap() {
        return new ConcurrentHashMap(0);
    }

    public static <E> Optional<E> ofThrowable(ThrowableSupplier<E> throwableSupplier, boolean bl) {
        Object t;
        block2: {
            t = null;
            try {
                t = throwableSupplier.get();
            }
            catch (Throwable throwable) {
                if (!bl) break block2;
                log.warn("Exception in creating Optional: {}, {}", (Object)throwable.getClass().getSimpleName(), (Object)throwable.getMessage());
            }
        }
        return Optional.ofNullable(t);
    }

    public static <E> Optional<E> ofThrowable(ThrowableSupplier<E> throwableSupplier) {
        return FunctionalUtils.ofThrowable(throwableSupplier, false);
    }

    public static <E> Stream<E> streamOfThrowable(ThrowableSupplier<E> throwableSupplier) {
        Object t = null;
        try {
            t = throwableSupplier.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (t != null) {
            return Stream.of(t);
        }
        return Stream.empty();
    }

    public static <E, F> Map<E, F> immutable(Map<E, F> map) {
        if (map instanceof AbstractMap) {
            return Collections.unmodifiableMap(map);
        }
        return map;
    }

    public static <E> List<E> immutable(List<E> list) {
        if (list instanceof AbstractList) {
            return Collections.unmodifiableList(list);
        }
        return list;
    }

    public static <E> Set<E> immutable(Set<E> set) {
        if (set instanceof AbstractSet) {
            return Collections.unmodifiableSet(set);
        }
        return set;
    }

    public static <E> Stream<E> streamFromOptional(Optional<E> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }
}

