/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class IdentityHashSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private transient IdentityHashMap<E, Boolean> map;
    private static final long serialVersionUID = -5024744406713321676L;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(int n) {
        this.map = new IdentityHashMap(n);
    }

    public IdentityHashSet(Collection<? extends E> collection) {
        this.map = new IdentityHashMap();
        this.addAll(collection);
    }

    @Override
    public boolean add(E e) {
        if (this.map.containsKey(e)) {
            return false;
        }
        this.internalAdd(e);
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        Iterator<E> iterator = this.iterator();
        IdentityHashSet<E> identityHashSet = new IdentityHashSet<E>(this.size() * 2);
        while (iterator.hasNext()) {
            super.internalAdd(iterator.next());
        }
        return identityHashSet;
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) != null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    private void internalAdd(E e) {
        this.map.put(e, Boolean.TRUE);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Iterator<E> iterator = this.iterator();
        objectOutputStream.writeInt(this.size() * 2);
        objectOutputStream.writeInt(this.size());
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        this.map = new IdentityHashMap(n);
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            this.internalAdd(IdentityHashSet.uncheckedCast(object));
        }
    }

    public static <E> E uncheckedCast(Object object) {
        return (E)object;
    }
}

