/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import java.lang.ref.SoftReference;
import java.util.function.Supplier;

public abstract class Lazy<E> {
    private SoftReference<E> implOrNullCache = null;
    private E implOrNull = null;

    void simulateGC() {
        if (this.implOrNullCache != null) {
            this.implOrNullCache.clear();
        }
    }

    public synchronized E get() {
        E e = this.getIfDefined();
        if (e == null) {
            e = this.compute();
            if (this.isCache()) {
                this.implOrNullCache = new SoftReference<E>(e);
            } else {
                this.implOrNull = e;
            }
        }
        assert (e != null);
        return e;
    }

    protected abstract E compute();

    public abstract boolean isCache();

    public E getIfDefined() {
        if (this.implOrNullCache != null) {
            assert (this.implOrNull == null);
            return this.implOrNullCache.get();
        }
        return this.implOrNull;
    }

    public boolean isGarbageCollected() {
        return this.isCache() && (this.implOrNullCache == null || this.implOrNullCache.get() == null);
    }

    public static <E> Lazy<E> from(final E e) {
        Lazy lazy = new Lazy<E>(){

            @Override
            protected E compute() {
                return e;
            }

            @Override
            public boolean isCache() {
                return false;
            }
        };
        lazy.implOrNull = e;
        return lazy;
    }

    public static <E> Lazy<E> of(final Supplier<E> supplier) {
        return new Lazy<E>(){

            @Override
            protected E compute() {
                return supplier.get();
            }

            @Override
            public boolean isCache() {
                return false;
            }
        };
    }

    public static <E> Lazy<E> cache(final Supplier<E> supplier) {
        return new Lazy<E>(){

            @Override
            protected E compute() {
                return supplier.get();
            }

            @Override
            public boolean isCache() {
                return true;
            }
        };
    }
}

