/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import ai.eloquent.util.RuntimeInterruptedException;
import ai.eloquent.util.SafeTimer;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.TimerUtils;
import ai.eloquent.util.Uninterruptably;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeTimerMock
implements SafeTimer {
    private static final Logger log = LoggerFactory.getLogger(SafeTimerMock.class);
    static long mockTime = 0L;
    static final List<SafeTimerMock> timerMocks = new ArrayList<SafeTimerMock>();
    private static final ReentrantLock timerLock = new ReentrantLock();
    private static final Condition timerCondition = timerLock.newCondition();
    private static final Multimap<Long, ScheduledTask> queue = ArrayListMultimap.create();
    public final List<ScheduledTask> scheduled;

    public SafeTimerMock() {
        block6: {
            this.scheduled = Collections.synchronizedList(new ArrayList());
            try {
                if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        timerMocks.add(this);
                        break block6;
                    }
                    finally {
                        timerLock.unlock();
                    }
                }
                throw new RuntimeException("Failed to get lock in tryLock()");
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void advanceTime(long l) {
        block26: {
            boolean bl = false;
            long l2 = mockTime + l;
            while (true) {
                ArrayList arrayList;
                block25: {
                    try {
                        if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                            try {
                                Object object = queue;
                                synchronized (object) {
                                    arrayList = new ArrayList(queue.get((Object)mockTime));
                                }
                                object = new ArrayList();
                                for (ScheduledTask scheduledTask : arrayList) {
                                    if (scheduledTask.startTime >= mockTime - 1L && scheduledTask.period <= 0L) {
                                        object.add(scheduledTask);
                                    }
                                    Multimap<Long, ScheduledTask> multimap = queue;
                                    synchronized (multimap) {
                                        queue.remove((Object)mockTime, (Object)scheduledTask);
                                        queue.remove((Object)(mockTime - 1L), (Object)scheduledTask);
                                    }
                                }
                                if (object.size() > 0) {
                                    bl = true;
                                    for (SafeTimerMock safeTimerMock : timerMocks) {
                                        safeTimerMock.scheduled.removeAll((Collection<?>)object);
                                    }
                                }
                                break block25;
                            }
                            finally {
                                timerLock.unlock();
                            }
                        }
                        log.warn("Failed to get lock in tryLock()");
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                }
                for (Object object : arrayList) {
                    ((ScheduledTask)object).runIfAppropriate();
                }
                if (mockTime >= l2) break;
                ++mockTime;
            }
            try {
                if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        if (bl) {
                            timerCondition.signalAll();
                        }
                        break block26;
                    }
                    finally {
                        timerLock.unlock();
                    }
                }
                throw new RuntimeException("Failed to get lock in tryLock()");
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetMockTime() {
        block10: {
            try {
                if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        mockTime = 0L;
                        timerMocks.clear();
                    }
                    finally {
                        timerLock.unlock();
                    }
                    Multimap<Long, ScheduledTask> multimap = queue;
                    synchronized (multimap) {
                        queue.clear();
                        break block10;
                    }
                }
                throw new RuntimeException("Failed to get lock in tryLock()");
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    public int numTasksScheduled() {
        return this.scheduled.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSilence() {
        long l;
        block14: {
            log.info("[{}] Waiting for SafeTimerMock to flush. scheduled={}", (Object)mockTime, (Object)this.numTasksScheduled());
            long l2 = l = this.now();
            try {
                if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        int n = 0;
                        while (this.numTasksScheduled() > 0 && n < 10000) {
                            ++n;
                            try {
                                timerCondition.await(1L, TimeUnit.SECONDS);
                                if (this.numTasksScheduled() == 0) {
                                    Uninterruptably.sleep(10L);
                                    if (this.numTasksScheduled() == 0) break;
                                }
                                if (this.now() > l2 + 60000L) {
                                    log.warn("[{}] Have not flushed transport after {}; scheduled={}", new Object[]{mockTime, TimerUtils.formatTimeDifference(this.now() - l), this.numTasksScheduled()});
                                    l2 = this.now();
                                }
                                if (this.now() <= l + Duration.ofMinutes(5L).toMillis()) continue;
                                throw new IllegalStateException("Transport hasn't flushed in 5 minutes. This almost certainly means a deadlock somewhere. now=" + mockTime + "; queue size=" + this.numTasksScheduled());
                            }
                            catch (InterruptedException interruptedException) {
                                log.warn("Interrupt waiting on transport. Transport still has {} scheduled events", (Object)this.numTasksScheduled());
                            }
                        }
                        if (this.numTasksScheduled() > 0) {
                            log.warn("There are still tasks scheduled after {} iterations of waiting; this is from a race condition on the timer", (Object)n);
                        }
                        break block14;
                    }
                    finally {
                        timerLock.unlock();
                    }
                }
                throw new RuntimeException("Failed to get lock in tryLock()");
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        log.info("[{}] Transport is flushed (scheduled={} real_flush_time={})", new Object[]{mockTime, this.numTasksScheduled(), TimerUtils.formatTimeDifference(this.now() - l)});
    }

    public static long time() {
        return mockTime;
    }

    @Override
    public long now() {
        return mockTime;
    }

    public void withTimerLock(Runnable runnable) {
        block6: {
            try {
                if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        runnable.run();
                        break block6;
                    }
                    finally {
                        timerLock.unlock();
                    }
                }
                throw new RuntimeException("Failed to get lock in tryLock()");
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeInterruptedException(interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(SafeTimerTask safeTimerTask, long l) {
        block6: {
            try {
                if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        ScheduledTask scheduledTask = new ScheduledTask(safeTimerTask, mockTime + l);
                        this.scheduled.add(scheduledTask);
                        break block6;
                    }
                    finally {
                        timerLock.unlock();
                    }
                }
                throw new RuntimeException("Failed to get lock in tryLock()");
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeInterruptedException(interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(SafeTimerTask safeTimerTask, long l, long l2) {
        block6: {
            try {
                if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        ScheduledTask scheduledTask = new ScheduledTask(safeTimerTask, mockTime + l, l2);
                        safeTimerTask.registerCancelCallback(() -> {
                            block6: {
                                try {
                                    if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                                        try {
                                            this.scheduled.remove(scheduledTask);
                                            timerCondition.signalAll();
                                            break block6;
                                        }
                                        finally {
                                            timerLock.unlock();
                                        }
                                    }
                                    throw new IllegalStateException("Could not take lock on timer cancel for 10 seconds");
                                }
                                catch (InterruptedException interruptedException) {
                                    throw new RuntimeException(interruptedException);
                                }
                            }
                        });
                        this.scheduled.add(scheduledTask);
                        break block6;
                    }
                    finally {
                        timerLock.unlock();
                    }
                }
                throw new RuntimeException("Failed to get lock in tryLock()");
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeInterruptedException(interruptedException);
            }
        }
    }

    @Override
    public void scheduleAtFixedRate(SafeTimerTask safeTimerTask, long l, long l2) {
        this.schedule(safeTimerTask, l, l2);
    }

    @Override
    public void scheduleAtFixedRate(SafeTimerTask safeTimerTask, long l) {
        this.scheduleAtFixedRate(safeTimerTask, 0L, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        block7: {
            try {
                if (timerLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        timerMocks.remove(this);
                        ArrayList<ScheduledTask> arrayList = new ArrayList<ScheduledTask>(this.scheduled);
                        for (ScheduledTask scheduledTask : arrayList) {
                            scheduledTask.task.cancel();
                        }
                        this.scheduled.clear();
                        timerCondition.signalAll();
                        break block7;
                    }
                    finally {
                        timerLock.unlock();
                    }
                }
                throw new RuntimeException("Failed to get lock in tryLock()");
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    public class ScheduledTask {
        public final SafeTimerTask task;
        public final long startTime;
        public final long period;
        public final long scheduledAt;

        public ScheduledTask(SafeTimerTask safeTimerTask, long l) {
            this(safeTimerTask, l, -1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScheduledTask(SafeTimerTask safeTimerTask, long l, long l2) {
            this.task = safeTimerTask;
            this.startTime = l;
            this.period = l2;
            this.scheduledAt = SafeTimerMock.this.now();
            Multimap multimap = queue;
            synchronized (multimap) {
                queue.put((Object)l, (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean runIfAppropriate() {
            long l;
            if (this.task.cancelled) {
                return true;
            }
            if (this.period == -1L) {
                if (mockTime >= this.startTime) {
                    this.task.run(Optional.empty());
                    return true;
                }
                return false;
            }
            if (mockTime >= this.startTime && (l = (mockTime - this.startTime) % this.period) == 0L) {
                this.task.run(Optional.empty());
                Multimap multimap = queue;
                synchronized (multimap) {
                    queue.put((Object)(mockTime + this.period), (Object)this);
                }
            }
            return false;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ScheduledTask scheduledTask = (ScheduledTask)object;
            return this.startTime == scheduledTask.startTime && this.period == scheduledTask.period && this.scheduledAt == scheduledTask.scheduledAt && Objects.equals(this.task, scheduledTask.task);
        }

        public int hashCode() {
            return Objects.hash(this.task, this.startTime, this.period, this.scheduledAt);
        }
    }
}

