/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.util.Lazy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SafeTimerTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(SafeTimerTask.class);
    private static final Lazy<ExecutorService> POOL = Lazy.of(() -> RaftLifecycle.global.managedThreadPool("timertask"));
    public boolean cancelled = false;
    private final List<Runnable> onCancelCallbacks = new ArrayList<Runnable>();
    private AtomicInteger runningCount = new AtomicInteger(0);
    public static final int MAX_SIMULTANEOUS_RUNS = 1;

    @Override
    public void run() {
        this.run(Optional.of(this.pool()));
    }

    public void run(Optional<Executor> optional) {
        if (this.cancelled) {
            return;
        }
        if (!optional.isPresent()) {
            try {
                this.runUnsafe();
            }
            catch (Throwable throwable) {
                log.warn("SafeTimerTask caught a thrown exception.", throwable);
            }
        } else {
            Executor executor = optional.get();
            try {
                if (!(executor instanceof ExecutorService) || !((ExecutorService)executor).isTerminated() && !((ExecutorService)executor).isShutdown()) {
                    if (this.runningCount.incrementAndGet() <= 1) {
                        try {
                            optional.get().execute(() -> {
                                try {
                                    this.runUnsafe();
                                }
                                catch (Throwable throwable) {
                                    log.warn("SafeTimerTask caught a thrown exception.", throwable);
                                }
                                finally {
                                    this.runningCount.decrementAndGet();
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            this.runningCount.decrementAndGet();
                            log.warn("Could not submit timer task to pool: ", throwable);
                        }
                    } else {
                        int n = this.runningCount.decrementAndGet();
                        if (n >= 5) {
                            log.warn("SafeTimerTask is not running request, because we already have {} running", (Object)n);
                        } else {
                            log.debug("SafeTimerTask is not running request, because we already have {} running", (Object)n);
                        }
                    }
                } else {
                    log.warn("Trying to run a task even though our managedThreadPool for running tasks has been shut down.");
                }
            }
            catch (Throwable throwable) {
                log.warn("SafeTimerTask caught an exception when starting a thread to execute an event.", throwable);
            }
        }
    }

    public void run(Executor executor) {
        this.run(Optional.of(executor));
    }

    public void registerCancelCallback(Runnable runnable) {
        this.onCancelCallbacks.add(runnable);
    }

    @Override
    public boolean cancel() {
        boolean bl = super.cancel();
        for (Runnable runnable : this.onCancelCallbacks) {
            runnable.run();
        }
        this.cancelled = true;
        return bl;
    }

    protected ExecutorService pool() {
        return POOL.get();
    }

    public abstract void runUnsafe() throws Throwable;
}

