/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Span
implements Iterable<Long>,
Comparable<Span>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final long begin;
    public final long end;

    public Span(long l, long l2) {
        this.begin = l;
        this.end = l2;
    }

    public boolean contains(Span span) {
        return this.begin <= span.begin && this.end >= span.end;
    }

    public long length() {
        return this.end - this.begin;
    }

    public boolean overlaps(Span span) {
        if (this.begin == this.end || span.begin == span.end) {
            return false;
        }
        return this.contains(span) || span.contains(this) || this.end > span.end && this.begin < span.end || span.end > this.end && span.begin < this.end || this.equals(span);
    }

    public long overlap(Span span) {
        if (this.contains(span) || span.contains(this)) {
            return Math.min(this.end - this.begin, span.end - span.begin);
        }
        if (this.end > span.end && this.begin < span.end || span.end > this.end && span.begin < this.end) {
            return Math.min(this.end, span.end) - Math.max(this.begin, span.begin);
        }
        return 0L;
    }

    public static Span intersect(Span span, Span span2) {
        long l;
        long l2 = Math.max(span.begin, span2.begin);
        if (l2 < (l = Math.min(span.end, span2.end))) {
            return new Span(l2, l);
        }
        if (span.begin == span2.end) {
            return new Span(span.begin, span.begin);
        }
        if (span.end == span2.begin) {
            return new Span(span.end, span.end);
        }
        return new Span(0L, 0L);
    }

    public static Span fromValues(long l, long l2) {
        if (l < l2) {
            return new Span(l, l2);
        }
        return new Span(l2, l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Span span = (Span)object;
        return this.begin == span.begin && this.end == span.end;
    }

    public int hashCode() {
        return (int)this.begin ^ (int)this.end;
    }

    public String toString() {
        return "[" + this.begin + ", " + this.end + ")";
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private long i;
            {
                this.i = Span.this.begin;
            }

            @Override
            public boolean hasNext() {
                return this.i < Span.this.end;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.i;
                return this.i - 1L;
            }
        };
    }

    @Override
    public int compareTo(Span span) {
        int n = Long.compare(this.begin, span.begin);
        if (n != 0) {
            return n;
        }
        return Long.compare(this.end, span.end);
    }

    public boolean contains(int n) {
        return (long)n >= this.begin && (long)n < this.end;
    }

    public long middle() {
        return (this.end + this.begin) / 2L;
    }
}

