/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackTrace {
    private static final Logger log = LoggerFactory.getLogger(StackTrace.class);
    private final List<StackTraceElement> trace;
    private final String repr;

    public StackTrace() {
        this(Thread.currentThread().getStackTrace());
    }

    public StackTrace(StackTraceElement[] stackTraceElementArray) {
        this(Arrays.asList(stackTraceElementArray));
    }

    public StackTrace(List<StackTraceElement> list) {
        this.trace = list;
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : list) {
            if (stackTraceElement.getClassName().equals(StackTrace.class.getName()) || stackTraceElement.getClassName().equals(Thread.class.getName())) continue;
            stringBuilder.append(stackTraceElement.getClassName().replaceAll("^ai.eloquent.", "").replaceAll("^java.lang.", "").replaceAll("^java.util.", "j.u.").replaceAll("^org.eclipse.jetty.", "jetty.")).append('.').append(stackTraceElement.getMethodName());
            if (stackTraceElement.getLineNumber() >= 0) {
                stringBuilder.append(" @ ").append(stackTraceElement.getLineNumber());
            } else {
                stringBuilder.append(" @ ???");
            }
            stringBuilder.append("\n");
        }
        this.repr = stringBuilder.toString().trim();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StackTrace stackTrace = (StackTrace)object;
        return Objects.equals(this.repr, stackTrace.repr);
    }

    public int hashCode() {
        return Objects.hash(this.repr);
    }

    public String toString() {
        return this.repr;
    }
}

