/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <X> String join(Iterable<X> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (X x : iterable) {
            if (!bl) {
                stringBuilder.append(string);
            } else {
                bl = false;
            }
            stringBuilder.append(x);
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, String string) {
        return StringUtils.join(Arrays.asList(objectArray), string);
    }

    public static String join(Object[] objectArray, int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder(127);
        boolean bl = true;
        for (int i = n; i < n2; ++i) {
            if (bl) {
                stringBuilder.append(objectArray[i]);
                bl = false;
                continue;
            }
            stringBuilder.append(string).append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String join(String[] stringArray, String string) {
        return StringUtils.join(Arrays.asList(stringArray), string);
    }

    public static <E> String join(List<? extends E> list, String string, Function<E, String> function, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        n = Math.max(n, 0);
        n2 = Math.min(n2, list.size());
        for (int i = n; i < n2; ++i) {
            if (!bl) {
                stringBuilder.append(string);
            } else {
                bl = false;
            }
            stringBuilder.append(function.apply(list.get(i)));
        }
        return stringBuilder.toString();
    }

    public static <X> String join(Stream<X> stream, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuilder.append(string);
            } else {
                bl = false;
            }
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }
}

