/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import java.time.Instant;

public class TimerUtils {
    public static boolean mockNow = false;

    public static Instant mockableNow() {
        if (mockNow) {
            return Instant.ofEpochMilli(1509651000000L);
        }
        return Instant.now();
    }

    public static void formatTimeDifference(long l, StringBuilder stringBuilder) {
        if (l < 100L) {
            stringBuilder.append(l).append(" ms");
            return;
        }
        int n = (int)l % 1000;
        long l2 = l / 1000L;
        int n2 = (int)l2 % 60;
        int n3 = (int)(l2 /= 60L) % 60;
        int n4 = (int)(l2 /= 60L) % 24;
        int n5 = (int)(l2 /= 24L);
        if (n5 > 0) {
            stringBuilder.append(n5).append(n5 > 1 ? " days, " : " day, ");
        }
        if (n4 > 0) {
            stringBuilder.append(n4).append(n4 > 1 ? " hours, " : " hour, ");
        }
        if (n3 > 0) {
            if (n3 < 10) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n3).append(":");
        }
        if (n3 > 0 && n2 < 10) {
            stringBuilder.append("0");
        }
        if (n5 == 0 && n4 == 0 && n3 == 0 && n2 < 30) {
            stringBuilder.append(n2).append(".");
            if (n >= 100) {
                stringBuilder.append(n);
            } else if (n >= 10) {
                stringBuilder.append("0").append(n);
            } else {
                stringBuilder.append("00").append(n);
            }
        } else {
            stringBuilder.append(n2);
        }
        if (n3 > 0) {
            stringBuilder.append(" minutes");
        } else {
            stringBuilder.append(" seconds");
        }
    }

    public static String formatTimeDifference(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        TimerUtils.formatTimeDifference(l, stringBuilder);
        return stringBuilder.toString();
    }

    public static String formatTimeSince(long l) {
        return TimerUtils.formatTimeDifference(System.currentTimeMillis() - l);
    }
}

