/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.util;

import ai.eloquent.util.RuntimeInterruptedException;
import java.time.Duration;

public class Uninterruptably {
    public static void sleep(long l) {
        if (l <= 0L) {
            return;
        }
        long l2 = System.currentTimeMillis() + l;
        while (System.currentTimeMillis() < l2) {
            try {
                long l3 = l2 - System.currentTimeMillis();
                if (l3 <= 0L) continue;
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeInterruptedException(interruptedException);
            }
        }
    }

    public static void sleep(Duration duration) {
        Uninterruptably.sleep(duration.toMillis());
    }

    public static void join(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Uninterruptably.join(thread);
        }
        if (thread.isAlive()) {
            Uninterruptably.join(thread);
        }
    }
}

