/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.web;

import ai.eloquent.error.RaftErrorListener;
import ai.eloquent.monitoring.Prometheus;
import ai.eloquent.stats.IntCounter;
import ai.eloquent.util.StackTrace;
import ai.eloquent.util.SystemUtils;
import ai.eloquent.util.TimerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackedExecutorService
implements ExecutorService {
    private static final Logger log = LoggerFactory.getLogger(TrackedExecutorService.class);
    private static ArrayList<RaftErrorListener> errorListeners = new ArrayList();
    private final ExecutorService impl;
    private final String name;
    private final Object gaugeQueueSize;
    private final Object counterTaskCount;
    private final Object summaryRuntime;
    private final Object summaryQueueTime;
    private long lastPaged = 0L;
    private long pageAboveThreadCount = 128L;

    public void addErrorListener(RaftErrorListener raftErrorListener) {
        errorListeners.add(raftErrorListener);
    }

    public void removeErrorListener(RaftErrorListener raftErrorListener) {
        errorListeners.remove(raftErrorListener);
    }

    public void clearErrorListeners() {
        errorListeners.clear();
    }

    private void throwRaftError(String string, String string2) {
        errorListeners.forEach(raftErrorListener -> raftErrorListener.accept(string, string2, Thread.currentThread().getStackTrace()));
    }

    public TrackedExecutorService(String string, ExecutorService executorService) {
        this.impl = executorService;
        this.name = string.replace('-', '_').replace(' ', '_');
        this.gaugeQueueSize = Prometheus.gaugeBuild(this.name + "_queue_size", "The number of tasks currently in pool " + this.name);
        this.counterTaskCount = Prometheus.counterBuild(this.name + "_total_tasks", "The number of tasks that have run in pool " + this.name);
        this.summaryRuntime = Prometheus.summaryBuild(this.name + "_runtime", "The time it takes for tasks to run in pool " + this.name, new String[0]);
        this.summaryQueueTime = Prometheus.summaryBuild(this.name + "_queuetime", "The time it takes for tasks to be scheduled in pool " + this.name, new String[0]);
    }

    public void pageAboveThreadCount(int n) {
        this.pageAboveThreadCount = Math.max(1, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQueueSize() {
        Double d = Prometheus.gaugeGet(this.gaugeQueueSize);
        if (this.impl instanceof ThreadPoolExecutor && d > 128.0) {
            TrackedExecutorService trackedExecutorService = this;
            synchronized (trackedExecutorService) {
                if (d < (double)this.pageAboveThreadCount || System.currentTimeMillis() < this.lastPaged + 600000L) {
                    return;
                }
                this.lastPaged = System.currentTimeMillis();
                log.warn("A queue has more than 64 threads waiting on it: {} -- paging PagerDuty", (Object)d);
                Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
                IntCounter<List<Object>> intCounter = new IntCounter<List<Object>>();
                for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                    if (!entry.getKey().getName().startsWith(this.name)) continue;
                    intCounter.incrementCount(Arrays.asList((Object[])entry.getValue()));
                }
                IntCounter intCounter2 = new IntCounter();
                for (Map.Entry entry : intCounter.entrySet()) {
                    intCounter2.setCount(new StackTrace((List)entry.getKey()).toString(), (Integer)entry.getValue());
                }
                if (intCounter2.totalIntCount() >= 128) {
                    Map.Entry<Thread, StackTraceElement[]> entry;
                    entry = "thread-overload-" + this.name + SystemUtils.HOST;
                    this.throwRaftError((String)((Object)entry), "Too many threads on " + this.name);
                }
            }
        }
    }

    private Runnable wrap(Runnable runnable) {
        Object object = Prometheus.startTimer(this.summaryQueueTime, new String[0]);
        Prometheus.gaugeInc(this.gaugeQueueSize);
        Prometheus.counterInc(this.counterTaskCount);
        this.checkQueueSize();
        return () -> {
            Prometheus.observeDuration(object);
            Object object2 = Prometheus.startTimer(this.summaryRuntime, new String[0]);
            try {
                runnable.run();
            }
            finally {
                Prometheus.gaugeDec(this.gaugeQueueSize);
                Double d = Prometheus.observeDuration(object2);
                if (d > 60.0 && d != null) {
                    log.warn("Thread on executor {} took >1m to finish ({})", (Object)this.name, (Object)TimerUtils.formatTimeDifference(d.longValue() * 1000L));
                }
            }
        };
    }

    private <T> Callable<T> wrap(Callable<T> callable) {
        Object object = Prometheus.startTimer(this.summaryQueueTime, new String[0]);
        this.checkQueueSize();
        Prometheus.gaugeInc(this.gaugeQueueSize);
        Prometheus.counterInc(this.counterTaskCount);
        return () -> {
            Prometheus.observeDuration(object);
            Object object2 = Prometheus.startTimer(this.summaryRuntime, new String[0]);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                Prometheus.gaugeDec(this.gaugeQueueSize);
                Prometheus.observeDuration(object2);
            }
        };
    }

    @Override
    public void shutdown() {
        this.impl.shutdown();
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        return this.impl.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.impl.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.impl.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, @Nonnull TimeUnit timeUnit) throws InterruptedException {
        return this.impl.awaitTermination(l, timeUnit);
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Callable<T> callable) {
        return this.impl.submit(this.wrap(callable));
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Runnable runnable, T t) {
        return this.impl.submit(this.wrap(runnable), t);
    }

    @Override
    @Nonnull
    public Future<?> submit(@Nonnull Runnable runnable) {
        return this.impl.submit(this.wrap(runnable));
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.impl.invokeAll(collection.stream().map(this::wrap).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> collection, long l, @Nonnull TimeUnit timeUnit) throws InterruptedException {
        return this.impl.invokeAll(collection.stream().map(this::wrap).collect(Collectors.toList()), l, timeUnit);
    }

    @Override
    @Nonnull
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.impl.invokeAny(collection.stream().map(this::wrap).collect(Collectors.toList()));
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> collection, long l, @Nonnull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.impl.invokeAny(collection.stream().map(this::wrap).collect(Collectors.toList()), l, timeUnit);
    }

    @Override
    public void execute(@Nonnull Runnable runnable) {
        this.impl.execute(this.wrap(runnable));
    }

    public boolean equals(Object object) {
        return this.impl.equals(object);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public String toString() {
        return this.impl.toString();
    }
}

