package ai.engagely.openbot.model.network.interfaces

import ai.engagely.openbot.model.network.ApiConstants
import ai.engagely.openbot.model.pojos.external.apirequests.livechat.LiveAgentConnectionDetailsRequest
import ai.engagely.openbot.model.pojos.external.apiresponses.livechat.LiveAgentConnectionDetailsResponse
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.POST

interface LiveChatApi {

    companion object {
        private const val BASE_URL = ApiConstants.BASE_URL
        const val LIVE_AGENT_CONNECTION_DETAILS =
            "$BASE_URL/chatbot_backend/liveagent_connection_details"
    }

    @POST(LIVE_AGENT_CONNECTION_DETAILS)
    suspend fun getLiveAgentConnectionDetails(@Body request: LiveAgentConnectionDetailsRequest): Response<LiveAgentConnectionDetailsResponse>
}