package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IChatCustomFormItem(
    val htmlData: String,
    val widthFraction: Float,
    val showBubble: Boolean,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    isBotItem = isBotItem,
    date = date,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IChatCustomFormItem(
            htmlData = htmlData,
            widthFraction = widthFraction,
            showBubble = showBubble,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}