package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IFileItem(
    val fileUrl: String,
    val fileSize: Long,
    val fileName: String,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    date = date,
    isBotItem = isBotItem,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IFileItem(
            fileUrl = fileUrl,
            fileSize = fileSize,
            fileName = fileName,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}