package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IVideoItem(
    val title: String?,
    val description: String?,
    val fileSize: Int?,
    val url: String,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    date = date,
    isBotItem = isBotItem,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IVideoItem(
            title = title,
            description = description,
            fileSize = fileSize,
            url = url,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}