package ai.engagely.openbot.model.repositories

interface LanguageRepository {

    suspend fun setDefaultLanguage(languageCode: String)

    suspend fun setCurrentLanguage(languageCode: String)

    suspend fun getCurrentLanguage(): String?

    suspend fun getPreviousLanguage(): String?

    suspend fun updatePreviousWithCurrent()

    companion object {
        const val KEY_DEFAULT_LANGUAGE = "default_language"
        const val KEY_CURRENT_LANGUAGE = "current_language"
        const val KEY_PREVIOUS_LANGUAGE = "previous_language"
    }
}