package ai.engagely.openbot.model.repositories.impl

import ai.engagely.openbot.model.localstorage.SimpleKeyValueStorage
import ai.engagely.openbot.model.repositories.LanguageRepository
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.withContext

class AppLanguageRepository(
    private val dispatcher: CoroutineDispatcher,
    private val simpleKeyValueStorage: SimpleKeyValueStorage
) : LanguageRepository {

    override suspend fun setDefaultLanguage(languageCode: String) {
        withContext(dispatcher) {
            simpleKeyValueStorage.storeStringDataForKey(
                LanguageRepository.KEY_DEFAULT_LANGUAGE,
                languageCode
            )
        }
    }

    override suspend fun setCurrentLanguage(languageCode: String) {
        withContext(dispatcher) {
            updatePreviousWithCurrent()
            simpleKeyValueStorage.storeStringDataForKey(
                LanguageRepository.KEY_CURRENT_LANGUAGE,
                languageCode
            )
        }
    }

    override suspend fun updatePreviousWithCurrent() {
        getCurrentLanguage()?.let { currentLanguage ->
            simpleKeyValueStorage.storeStringDataForKey(
                LanguageRepository.KEY_PREVIOUS_LANGUAGE,
                currentLanguage
            )
        }
    }

    override suspend fun getCurrentLanguage(): String? {
        return withContext(dispatcher) {
            simpleKeyValueStorage.readStringDataForKey(LanguageRepository.KEY_CURRENT_LANGUAGE)
                ?: simpleKeyValueStorage.readStringDataForKey(LanguageRepository.KEY_DEFAULT_LANGUAGE)
        }
    }

    override suspend fun getPreviousLanguage(): String? {
        return withContext(dispatcher) {
            simpleKeyValueStorage.readStringDataForKey(LanguageRepository.KEY_PREVIOUS_LANGUAGE)
        }
    }
}