package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewDialogueCarousalItemBinding
import ai.engagely.openbot.model.pojos.internal.history.ICarousalData
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class DialogueCarousalItemView : FrameLayout {

    private var binding: ViewDialogueCarousalItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewDialogueCarousalItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        iCarousalData: ICarousalData,
        imageHeight: Int,
        itemClickListener: OnClickListener
    ) {
        binding?.ivImage?.apply {
            val lpToUpdate = layoutParams
            lpToUpdate.height = imageHeight
            layoutParams = lpToUpdate

            iCarousalData.imageData?.let { bitmap ->
                ImageUtils.loadImage(context, bitmap, this)
            }
        }

        binding?.tvImageDetails?.text = iCarousalData.imageDetails

        binding?.llCarousalButtons?.apply {
            removeAllViews()
            iCarousalData.buttonData?.forEach {
                addView(HorizontalDividerView(context))

                val button = DialogueCarousalButtonView(context)
                button.setData(it, itemClickListener)
                addView(button)
            }
        }
    }
}