package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemChatImageBinding
import ai.engagely.openbot.model.constants.AppConstants
import ai.engagely.openbot.model.pojos.internal.chat.IImageItem
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemImageView : FrameLayout {

    private var binding: ViewItemChatImageBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemChatImageBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iImageItem: IImageItem?) {
        iImageItem?.imageUrl?.let { imageUrl ->
            binding?.ivDialogue?.let {
                ImageUtils.loadImage(context, imageUrl, it)
            }
        }

        binding?.tvTime?.setData(iImageItem?.date)
    }

    fun calculateAndUpdateImageHeight(screenWidth: Int) {
        val imageLeftSpacing = resources.getDimension(R.dimen.common_card_horizontal_margin)
        val imageWidth = (screenWidth * AppConstants.ITEM_IMAGE_WIDTH_PERCENTAGE) - imageLeftSpacing
        val imageHeight =
            (imageWidth * AppConstants.ITEM_IMAGE_HEIGHT_REF) / AppConstants.ITEM_IMAGE_WIDTH_REF
        val dialogueImageLayoutParams = binding?.ivDialogue?.layoutParams
        dialogueImageLayoutParams?.height = imageHeight.toInt()
        dialogueImageLayoutParams?.width = imageWidth.toInt()
        binding?.ivDialogue?.layoutParams = dialogueImageLayoutParams
    }
}