package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemVideoBinding
import ai.engagely.openbot.model.pojos.internal.chat.IVideoItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemVideoView : FrameLayout {

    private var binding: ViewItemVideoBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemVideoBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iVideoItem: IVideoItem?, onItemClickListener: OnClickListener) {
        binding?.tvTitle?.text = iVideoItem?.title
        binding?.tvDescription?.text = iVideoItem?.description
        binding?.btPlay?.tag = iVideoItem
        binding?.btPlay?.setOnClickListener(onItemClickListener)
    }
}