package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewWelcomeImageBinding
import ai.engagely.openbot.model.constants.AppConstants
import ai.engagely.openbot.model.utils.general.ImageUtils
import ai.engagely.openbot.model.utils.general.ViewUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.ViewTreeObserver
import android.widget.FrameLayout

class WelcomeImageView : FrameLayout {

    private var binding: ViewWelcomeImageBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewWelcomeImageBinding.inflate(LayoutInflater.from(context), this, true)

        //Adjust image height
        binding?.ivWelcomeImage?.viewTreeObserver?.addOnGlobalLayoutListener(object :
            ViewTreeObserver.OnGlobalLayoutListener {
            override fun onGlobalLayout() {
                ViewUtils.removeGlobalLayoutListener(binding?.ivWelcomeImage, this)
                val width = binding?.ivWelcomeImage?.width ?: 0
                if (width > 0) {
                    val height =
                        (width * AppConstants.WELCOME_IMAGE_HEIGHT_REF) / AppConstants.WELCOME_IMAGE_WIDTH_REF
                    val welcomeImageLayoutParams = binding?.ivWelcomeImage?.layoutParams
                    welcomeImageLayoutParams?.height = height.toInt()
                    binding?.ivWelcomeImage?.layoutParams = welcomeImageLayoutParams
                }
            }
        })
    }

    fun setData(url: String) {
        binding?.ivWelcomeImage?.let {
            ImageUtils.loadImage(context, url, it)
        }
    }
}