package ai.engagely.openbot.view.dialogfragments

import android.app.DatePickerDialog
import android.app.Dialog
import android.os.Bundle
import android.widget.DatePicker
import androidx.fragment.app.DialogFragment
import java.util.*

class DatePickerFragment(
    private val title: String? = null,
    private val selectedDate: Date? = null,
    private val onDateSelected: ((date: Date) -> Unit)? = null
) : DialogFragment(), DatePickerDialog.OnDateSetListener {

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val calendar = Calendar.getInstance()
        selectedDate?.let {
            calendar.time = it
        }
        val year = calendar.get(Calendar.YEAR)
        val month = calendar.get(Calendar.MONTH)
        val day = calendar.get(Calendar.DAY_OF_MONTH)

        return context?.let {
            DatePickerDialog(it, this, year, month, day).apply {
                title?.let { title ->
                    setTitle(title)
                }
            }
        } ?: run {
            super.onCreateDialog(savedInstanceState)
        }
    }

    override fun onDateSet(view: DatePicker?, year: Int, month: Int, day: Int) {
        val calendar = Calendar.getInstance()
        calendar.set(year, month, day)
        onDateSelected?.invoke(calendar.time)
    }
}