package ai.engagely.openbot.model.network.interfaces

import ai.engagely.openbot.model.network.ApiConstants
import ai.engagely.openbot.model.pojos.external.apiresponses.form.FormSubmitResponse
import okhttp3.MultipartBody
import okhttp3.RequestBody
import retrofit2.Response
import retrofit2.http.Multipart
import retrofit2.http.POST
import retrofit2.http.Part
import retrofit2.http.PartMap

interface FormApi {
    companion object {
        private const val BASE_URL = ApiConstants.BASE_URL
        const val SUBMIT_FORM = "$BASE_URL/chatbot_backend/form_file_upload"
    }

    @Multipart
    @POST(SUBMIT_FORM)
    suspend fun submitForm(
        @PartMap formFields: Map<String, @JvmSuppressWildcards RequestBody>,
        @Part files: List<MultipartBody.Part>,
    ): Response<FormSubmitResponse>
}