package ai.engagely.openbot.model.network.interfaces

import ai.engagely.openbot.model.network.ApiConstants
import ai.engagely.openbot.model.pojos.external.apirequests.livechat.LiveAgentConnectionDetailsRequest
import ai.engagely.openbot.model.pojos.external.apiresponses.livechat.HandleMediaResponse
import ai.engagely.openbot.model.pojos.external.apiresponses.livechat.LiveAgentConnectionDetailsResponse
import okhttp3.MultipartBody
import okhttp3.RequestBody
import retrofit2.Response
import retrofit2.http.*

interface LiveChatApi {

    companion object {
        private const val BASE_URL = ApiConstants.BASE_URL
        const val LIVE_AGENT_CONNECTION_DETAILS =
            "$BASE_URL/chatbot_backend/liveagent_connection_details"
        const val HANDLE_MEDIA = "$BASE_URL/livechat_backend/handle_media"
    }

    @POST(LIVE_AGENT_CONNECTION_DETAILS)
    suspend fun getLiveAgentConnectionDetails(@Body request: LiveAgentConnectionDetailsRequest): Response<LiveAgentConnectionDetailsResponse>

    @Multipart
    @POST(HANDLE_MEDIA)
    suspend fun handleMedia(
        @PartMap formFields: Map<String, @JvmSuppressWildcards RequestBody>,
        @Part files: List<MultipartBody.Part>,
    ): Response<HandleMediaResponse>
}