package ai.engagely.openbot.model.pojos.internal.chat

import ai.engagely.openbot.model.pojos.internal.botsettings.IOptionsStyle
import java.util.*

class IMultipleOptionsItem(
    val options: List<IChatItemOption>,
    val optionsStyle: IOptionsStyle?,
    val optionsHeader: String?,
    date: Date? = null,
    isLoading: Boolean = false,
    isBotItem: Boolean = false,
    isHistoryItem: Boolean = false,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(date, isLoading, isBotItem, isHistoryItem, uuid, pendingData) {
    override fun makeACopy(): IChatItem {
        return IMultipleOptionsItem(
            options = options,
            optionsStyle = optionsStyle,
            optionsHeader = optionsHeader,
            date = date,
            isLoading = isLoading,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}
