package ai.engagely.openbot.model.repositories.impl

import ai.engagely.openbot.model.network.ApiClient
import ai.engagely.openbot.model.network.interfaces.HistoryApi
import ai.engagely.openbot.model.pojos.external.apirequests.history.GetChatHistoryRequest
import ai.engagely.openbot.model.pojos.external.apirequests.history.Location
import ai.engagely.openbot.model.pojos.internal.chat.IChatItem
import ai.engagely.openbot.model.repositories.ChatHistoryRepository
import ai.engagely.openbot.model.utils.converters.ChatResponseConverter
import ai.engagely.openbot.model.utils.exts.toMap
import ai.engagely.openbot.model.utils.general.LogUtils
import android.os.Bundle
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.withContext
import java.net.HttpURLConnection

class AppChatHistoryRepository(
    private val dispatcher: CoroutineDispatcher,
    private val chatResponseConverter: ChatResponseConverter
) :
    ChatHistoryRepository {

    override suspend fun getChatHistory(
        userId: String?,
        sessionId: String?,
        intId: String?,
        extras: Bundle?
    ): List<IChatItem>? {
        return withContext(dispatcher) {
            try {
                val location = Location(latitude = 0, longitude = 0)
                val request = GetChatHistoryRequest(
                    userId = userId,
                    queryParams = extras.toMap(),
                    sessionId = sessionId,
                    intId = intId,
                    location = location
                )
                val response = ApiClient.getInstance().getClient().create(HistoryApi::class.java)
                    .getChatHistory(request)
                if (response.isSuccessful && response.code() == HttpURLConnection.HTTP_OK
                    && response.body()?.success == true
                ) {
                    val chatItems = ArrayList<IChatItem>()
                    response.body()?.chatData?.forEach { chatDataItem ->
                        chatResponseConverter.convertHistoryItemToChatItem(
                            chatDataItem = chatDataItem,
                            sessionId = sessionId
                        )?.let {
                            chatItems.addAll(it)
                        }
                    }
                    return@withContext chatItems
                }
            } catch (e: Exception) {
                LogUtils.logException(e)
            }
            return@withContext null
        }
    }
}