package ai.engagely.openbot.model.utils.general

import ai.engagely.openbot.R
import android.content.Context
import android.graphics.Bitmap
import android.widget.ImageView
import androidx.core.content.ContextCompat
import com.bumptech.glide.Glide

object ImageUtils {

    fun loadImage(context: Context, bitmap: Bitmap, imageView: ImageView) {
        Glide.with(context).load(bitmap).into(imageView)
    }

    fun loadImage(context: Context, url: String, imageView: ImageView) {
        Glide.with(context).load(url)
            .placeholder(ContextCompat.getDrawable(context, R.color.image_loader_bg))
            .into(imageView)
    }
}