package ai.engagely.openbot.model.utils.general

object NumberUtils {

    fun parseInt(intString: String?): Int {
        return try {
            intString?.toInt() ?: 0
        } catch (e: Exception) {
            LogUtils.logException(e)
            0
        }
    }

    fun parseIntFromAny(intVar: Any?): Int? {
        return try {
            when (intVar) {
                is Double -> {
                    intVar.toInt()
                }
                is Float -> {
                    intVar.toInt()
                }
                is Int -> {
                    intVar
                }
                is Long -> {
                    intVar.toInt()
                }
                is String -> {
                    intVar.toInt()
                }
                else -> {
                    null
                }
            }
        } catch (e: Exception) {
            LogUtils.logException(e)
            null
        }
    }

    fun parseDouble(doubleString: String?): Double? {
        return try {
            doubleString?.toDouble()
        } catch (e: Exception) {
            LogUtils.logException(e)
            null
        }
    }

    fun convertPercentageStringToFraction(percentageString: String?): Float {
        return try {
            val parsedInt = percentageString?.replace(Regex("[^0-9]"), "")?.toInt() ?: 0
            val fraction = parsedInt / 100.0f
            if (fraction > 1f) {
                return 1f
            }
            fraction
        } catch (e: Exception) {
            LogUtils.logException(e)
            0.0f
        }
    }
}