package ai.engagely.openbot.model.utils.general

import ai.engagely.openbot.model.network.ApiConstants
import java.util.regex.Matcher
import java.util.regex.Pattern

object UrlUtils {

    fun getVideoId(videoUrl: String): String? {
        var videoId: String? = ""
        val regex =
            "http(?:s)?://(?:m.)?(?:www\\.)?youtu(?:\\.be/|be\\.com/(?:watch\\?(?:feature=youtu.be&)?v=|v/|embed/|user/(?:[\\w#]+/)+))([^&#?\\n]+)"
        val pattern: Pattern = Pattern.compile(regex, Pattern.CASE_INSENSITIVE)
        val matcher: Matcher = pattern.matcher(videoUrl)
        if (matcher.find()) {
            videoId = matcher.group(1)
        }
        return videoId
    }

    fun getYouTubeBannerUrl(url: String): String {
        val videoId = getVideoId(url) ?: ""
        return ApiConstants.YOUTUBE_BANNER_URL.replace(
            ApiConstants.YOUTUBE_BANNER_VIDEO_ID_SUBSTITUTE,
            videoId
        )
    }
}