package ai.engagely.openbot.model.utils.general

import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Color
import android.util.Base64
import android.view.View
import android.view.ViewTreeObserver

object ViewUtils {

    fun convertFromBase64ToBitmap(base64String: String?): Bitmap? {
        return try {
            val pureBase64Encoded = base64String?.substring(base64String.indexOf(",") + 1)
            val decodedBytes: ByteArray = Base64.decode(pureBase64Encoded, Base64.DEFAULT)
            BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.size)
        } catch (e: Exception) {
            LogUtils.log("Failed to convert based 64 string to bitmap - $e")
            null
        }
    }

    fun removeGlobalLayoutListener(v: View?, listener: ViewTreeObserver.OnGlobalLayoutListener) {
        v?.viewTreeObserver?.removeOnGlobalLayoutListener(listener)
    }

    fun parseColorSafely(color: String?, fallbackColor: String): Int {
        try {
            if (!color.isNullOrBlank()) {
                return Color.parseColor(color)
            }
            return Color.parseColor(fallbackColor)
        } catch (e: Exception) {
            return Color.parseColor(fallbackColor)
        }
    }
}