package ai.engagely.openbot.model.utils.helpers

import android.text.Editable
import android.text.TextWatcher
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.coroutineScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class DebouncingTextChangeListener(
    lifecycle: Lifecycle,
    private val delayInMillis: Long,
    private val onDebouncingTextChange: (String) -> Unit,
    private val onTextChange: (String) -> Unit
) : TextWatcher {

    private val coroutineScope = lifecycle.coroutineScope

    private var job: Job? = null

    override fun beforeTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {}

    override fun onTextChanged(newText: CharSequence?, p1: Int, p2: Int, p3: Int) {
        newText?.toString()?.let {
            onTextChange(it)
            if (delayInMillis == 0L) {
                onDebouncingTextChange(it)
                return
            }
        }

        job?.cancel()
        job = coroutineScope.launch {
            newText?.let {
                delay(delayInMillis)
                onDebouncingTextChange(it.toString())
            }
        }
    }

    override fun afterTextChanged(p0: Editable?) {}

}