package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewBotBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IBotChatWindowConfig
import ai.engagely.openbot.model.pojos.internal.botsettings.IBotDimensions
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.graphics.Bitmap
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import com.google.android.material.shape.CornerFamily
import com.google.android.material.shape.ShapeAppearanceModel

class BotView : FrameLayout {

    private var binding: ViewBotBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewBotBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setBotDimensions(botDimensions: IBotDimensions?) {
        setShape(botDimensions)
        setSize(botDimensions)
    }

    private fun setSize(botDimensions: IBotDimensions?) {
        val botImageSize = if (IBotChatWindowConfig.BotImageSize.STANDARD == botDimensions?.size)
            resources.getDimension(R.dimen.bot_logo_image_size).toInt()
        else resources.getDimension(R.dimen.bot_logo_image_size_small).toInt()
        binding?.imageView?.layoutParams = binding?.imageView?.layoutParams?.apply {
            width = botImageSize
            height = botImageSize
        }
        binding?.imageViewContainer?.layoutParams =
            binding?.imageViewContainer?.layoutParams?.apply {
                width = botImageSize
                height = botImageSize
            }

        val botSize = if (IBotChatWindowConfig.BotImageSize.STANDARD == botDimensions?.size)
            resources.getDimension(R.dimen.bot_logo_size).toInt()
        else resources.getDimension(R.dimen.bot_logo_size_small).toInt()
        layoutParams = layoutParams?.apply {
            width = botSize
            height = botSize
        }
    }

    private fun setShape(botDimensions: IBotDimensions?) {
        val cornerRadius =
            if (IBotChatWindowConfig.BotImageSize.STANDARD == botDimensions?.size)
                resources.getDimension(R.dimen.bot_logo_corner)
            else resources.getDimension(R.dimen.bot_logo_corner_small)
        val bottomRightCornerRadius =
            if (IBotChatWindowConfig.BotImageShape.TRIPPED == botDimensions?.shape)
                resources.getDimension(R.dimen.bot_logo_bottom_right_corner)
            else
                cornerRadius
        binding?.imageView?.shapeAppearanceModel?.let {
            binding?.imageView?.shapeAppearanceModel =
                buildCornerRadius(it, cornerRadius, bottomRightCornerRadius)
        }
        binding?.imageViewContainer?.shapeAppearanceModel?.let {
            binding?.imageViewContainer?.shapeAppearanceModel =
                buildCornerRadius(it, cornerRadius, bottomRightCornerRadius)
        }
        binding?.retryContainer?.shapeAppearanceModel?.let {
            binding?.retryContainer?.shapeAppearanceModel =
                buildCornerRadius(it, cornerRadius, bottomRightCornerRadius)
        }
    }

    private fun buildCornerRadius(
        it: ShapeAppearanceModel,
        cornerRadius: Float,
        bottomRightCornerRadius: Float
    ) = it.toBuilder()
        .setTopLeftCorner(CornerFamily.ROUNDED, cornerRadius)
        .setTopRightCorner(CornerFamily.ROUNDED, cornerRadius)
        .setBottomLeftCorner(CornerFamily.ROUNDED, cornerRadius)
        .setBottomRightCorner(CornerFamily.ROUNDED, bottomRightCornerRadius)
        .build()

    fun setLoading(isLoading: Boolean) {
        binding?.retryContainer?.visibility = GONE
        if (isLoading) {
            binding?.imageViewContainer?.visibility = GONE
            binding?.progressBar?.visibility = VISIBLE
        } else {
            binding?.progressBar?.visibility = GONE
            binding?.imageViewContainer?.visibility = VISIBLE
        }
    }

    fun setImage(bitmap: Bitmap) {
        binding?.imageView?.let {
            ImageUtils.loadImage(context, bitmap, it)
        }
    }

    fun setImageClickListener(listener: OnClickListener) {
        binding?.imageView?.setOnClickListener(listener)
    }

    fun setImageLongClickListener(listener: OnLongClickListener) {
        binding?.imageView?.setOnLongClickListener(listener)
    }

    fun setErrorView(isError: Boolean) {
        if (isError) {
            binding?.progressBar?.visibility = GONE
            binding?.imageViewContainer?.visibility = GONE
            binding?.retryContainer?.visibility = VISIBLE
        } else {
            binding?.retryContainer?.visibility = GONE
        }
    }

    fun setErrorRetryClickListener(listener: OnClickListener) {
        binding?.tvRetry?.setOnClickListener(listener)
    }
}