package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewFormCheckBoxesBinding
import ai.engagely.openbot.model.pojos.internal.history.IFormCheckboxesItem
import ai.engagely.openbot.model.pojos.internal.history.IFormItem
import ai.engagely.openbot.model.pojos.internal.history.IFormItemCheckableOption
import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.CheckBox
import android.widget.FrameLayout

class FormCheckBoxesView : FrameLayout {

    private var binding: ViewFormCheckBoxesBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewFormCheckBoxesBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iFormCheckboxesItem: IFormCheckboxesItem, themeColor: Int) {
        binding?.tvLabel?.text = iFormCheckboxesItem.labelName
        binding?.llCheckBoxes?.removeAllViews()
        iFormCheckboxesItem.options.forEach { option ->
            val checkBox = CheckBox(context)
            checkBox.text = option.label
            checkBox.isChecked = option.isChecked
            checkBox.buttonTintList = ColorStateList.valueOf(themeColor)
            checkBox.tag = option
            checkBox.setOnClickListener { view ->
                val optionTag = view.tag as IFormItemCheckableOption
                val newCheckedState = !optionTag.isChecked
                optionTag.isChecked = newCheckedState
                (view as CheckBox).isChecked = newCheckedState
            }
            binding?.llCheckBoxes?.addView(checkBox)
        }
        setError(iFormCheckboxesItem)
    }

    private fun setError(iFormItem: IFormItem) {
        binding?.tvError?.visibility =
            if (!iFormItem.errorMessage.isNullOrBlank()) VISIBLE else GONE
        binding?.tvError?.text = iFormItem.errorMessage
    }
}