package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewFormFileUploadBinding
import ai.engagely.openbot.model.pojos.internal.history.IFormFileItem
import ai.engagely.openbot.model.pojos.internal.history.IFormItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class FormFileUploadView : FrameLayout {

    private var binding: ViewFormFileUploadBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewFormFileUploadBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iFormFileItem: IFormFileItem, itemClickListener: OnClickListener) {
        binding?.tvLabel?.text = iFormFileItem.labelName

        binding?.tvFileName?.hint = resources.getString(R.string.choose_file)
        binding?.tvFileName?.setText(iFormFileItem.fileOriginalName)
        binding?.tvFileName?.tag = iFormFileItem
        binding?.tvFileName?.setTag(R.id.tag_form_view, this)
        binding?.tvFileName?.setOnClickListener(itemClickListener)

        binding?.tvBrowse?.tag = iFormFileItem
        binding?.tvBrowse?.setTag(R.id.tag_form_view, this)
        binding?.tvBrowse?.setOnClickListener(itemClickListener)



        setError(iFormFileItem)
    }

    fun updateFileData(fileName: String?) {
        binding?.tvFileName?.setText(fileName)
    }

    fun setError(iFormItem: IFormItem) {
        binding?.tvError?.visibility =
            if (!iFormItem.errorMessage.isNullOrBlank()) VISIBLE else GONE
        binding?.tvError?.text = iFormItem.errorMessage
    }
}