package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewChatTopJourneyBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IGreetingMessageWithHeader
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class GreetingMessageView : FrameLayout {

    private var binding: ViewChatTopJourneyBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewChatTopJourneyBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iGreetingMessage: IGreetingMessageWithHeader?) {
        if (iGreetingMessage == null) {
            visibility = GONE
            return
        }
        visibility = VISIBLE
        binding?.tvHeader?.text = iGreetingMessage.headerMessage

        binding?.llMessagesContainer?.removeAllViews()
        iGreetingMessage.messages.forEach {
            val messageItemView = GreetingMessageItemView(context)
            messageItemView.setData(it.message)
            binding?.llMessagesContainer?.addView(messageItemView)
        }

        val messageVisibility = if (iGreetingMessage.messages.isNullOrEmpty()) GONE else VISIBLE
        binding?.llMessagesContainer?.visibility = messageVisibility
        binding?.vTextDivider?.visibility = messageVisibility
    }

    fun setBgStripColor(color: Int) {
        binding?.vTopBgStrip?.setBackgroundColor(color)
    }
}