package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemAdvancedUrlBinding
import ai.engagely.openbot.model.pojos.internal.chat.IAdvancedUrlItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemAdvancedUrlView : FrameLayout {

    private var binding: ViewItemAdvancedUrlBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemAdvancedUrlBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iAdvancedUrlItem: IAdvancedUrlItem?, color: Int, onClickListener: OnClickListener) {
        binding?.urlButton?.setData(iAdvancedUrlItem?.urlText, false, color)
        binding?.urlButton?.tag = iAdvancedUrlItem
        binding?.urlButton?.setOnClickListener(onClickListener)
    }
}