package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemFileViewBinding
import ai.engagely.openbot.model.pojos.internal.chat.IFileItem
import ai.engagely.openbot.model.utils.general.FileUtils
import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemFileView : FrameLayout {

    private var binding: ViewItemFileViewBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemFileViewBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iFileItem: IFileItem?, themeColor: Int, itemClickListener: OnClickListener) {
        binding?.ivDownload?.imageTintList = ColorStateList.valueOf(themeColor)
        binding?.ivDownload?.tag = iFileItem
        binding?.ivDownload?.setOnClickListener(itemClickListener)

        binding?.tvFileName?.text = iFileItem?.fileName
        binding?.tvFileSize?.text = FileUtils.formatToFileSize(context, iFileItem?.fileSize ?: 0)

        binding?.tvTime?.setData(iFileItem?.date)
    }
}