package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemChatImageBinding
import ai.engagely.openbot.model.pojos.internal.chat.IImageItem
import ai.engagely.openbot.model.pojos.internal.common.IViewImageData
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemImageView : FrameLayout {

    private var binding: ViewItemChatImageBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemChatImageBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iImageItem: IImageItem?, bgColor: Int, onClickListener: OnClickListener) {
        iImageItem?.imageUrl?.let { imageUrl ->
            binding?.ivDialogue?.let {
                ImageUtils.loadImage(context, imageUrl, it)
            }
            binding?.ivDialogue?.tag = IViewImageData(imageUrl)
            binding?.ivDialogue?.setOnClickListener(onClickListener)
        }

        binding?.tvTime?.setData(iImageItem?.date)
        binding?.rlMessageContainer?.setCardBackgroundColor(bgColor)
    }
}