package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemLoadMoreBinding
import ai.engagely.openbot.model.utils.exts.overrideWithCustomColor
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemLoadMoreView : FrameLayout {

    private var binding: ViewItemLoadMoreBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemLoadMoreBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(color: Int) {
        binding?.rlLoadMoreContainer?.background?.overrideWithCustomColor(color)
    }
}