package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemMultipleOptionsBinding
import ai.engagely.openbot.model.pojos.internal.chat.IMultipleOptionsItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemMultipleOptionsView : FrameLayout {

    private var binding: ViewItemMultipleOptionsBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemMultipleOptionsBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        data: IMultipleOptionsItem?,
        buttonColor: Int,
        optionClickListener: OnClickListener
    ) {
        binding?.llMultipleOptionsContainer?.removeAllViews()
        data?.options?.forEach { chatItemOption ->
            val chatItemView =
                ItemOptionSimpleTextView(context = context)
            chatItemView.setData(chatItemOption.name, chatItemOption.isNew, buttonColor)
            chatItemView.tag = chatItemOption.optionObject
            chatItemView.setTag(R.id.tag_item_uuid, data.uuid)
            chatItemView.setOnClickListener(optionClickListener)
            binding?.llMultipleOptionsContainer?.addView(chatItemView)
        }
    }
}