package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemOptionSimpleTextBinding
import ai.engagely.openbot.model.utils.exts.setBorderBg
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout


class ItemOptionSimpleTextView : FrameLayout {

    private var binding: ViewItemOptionSimpleTextBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemOptionSimpleTextBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(optionName: String?, isNew: Boolean, color: Int) {
        binding?.tvOptionName?.text = optionName
        binding?.tvNew?.visibility = if (!isNew) GONE else VISIBLE
        binding?.tvOptionName?.setTextColor(color)

        val cornerRadius =
            resources.getDimension(R.dimen.common_card_corner_radius)
        val borderSize = resources.getDimension(R.dimen.chat_item_option_simple_text_bg_border_size)
        binding?.tvOptionName.setBorderBg(color, borderSize.toInt(), cornerRadius)
    }
}