package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemUrlItemBinding
import ai.engagely.openbot.model.pojos.internal.chat.IUrlsItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemUrlItemView : FrameLayout {

    private var binding: ViewItemUrlItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemUrlItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        url: String,
        iUrlsItem: IUrlsItem,
        linkColor: Int,
        onItemClickListener: OnClickListener
    ) {
        binding?.tvUrl?.text = url
        binding?.tvUrl?.setTextColor(linkColor)
        binding?.tvUrl?.tag = iUrlsItem
        binding?.tvUrl?.setTag(R.id.tag_item_url, url)
        binding?.tvUrl?.setOnClickListener(onItemClickListener)
    }
}