package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemUrlsBinding
import ai.engagely.openbot.model.pojos.internal.chat.IUrlsItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemUrlsView : FrameLayout {

    private var binding: ViewItemUrlsBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemUrlsBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        iUrlsItem: IUrlsItem?,
        bgColor: Int,
        linkColor: Int,
        onItemClickListener: OnClickListener
    ) {
        binding?.cvMessagesContainer?.setCardBackgroundColor(bgColor)
        binding?.llMessagesContainer?.removeAllViews()
        iUrlsItem?.urls?.forEachIndexed { index, item ->
            if (index > 0) {
                val verticalSpace = VerticalSpaceView(context)
                binding?.llMessagesContainer?.addView(verticalSpace)
            }
            val itemView = ItemUrlItemView(context)
            itemView.setData(
                url = item,
                iUrlsItem = iUrlsItem,
                linkColor = linkColor,
                onItemClickListener = onItemClickListener
            )
            binding?.llMessagesContainer?.addView(itemView)
        }
        binding?.tvTime?.setData(iUrlsItem?.date)
    }
}